#pragma rtGlobals=1		// Use modern global access method.

Menu "SAS 2D"
	"-"
	"Image Analysis Panel",Twod_Panel()
	"-"
	submenu "Load images"
		 "Load .MPA text file",LoadMPA()
		 "Load Image Tiff,jpg,pict",LoadImage()
		 "Load Binary 1944 x2400", Load_Binary(1944,2400,0)
//	"Load Binary 1024 x1024", Load_Binary(1024,1024,0)
	end
		"Display Image",Make2D()
	"-"
	"1d Data Reduction", complete()
	submenu "Components of 1d Data reduction"
			"Enter Hardware Parameters", GetSpecs()
			"Circular Average 2d  image to generate 1d wave", Average2D()
			"Correct 1d wave for transmission, sensitivity & Dark Current",Normalize()
			"Subtract corrected background from corrected sample", Subback()
			"Normalize by abs Intensity factor over thickness", dividebythickness()
			"-"
				"Correct 2d or 1d for trans, sens & dark and sub bkg", Correct1dor2d()

	
		"View 1d Data",Plot_N_B_Data()
		"View 1d Data & background",Plotall()
		end
		"-"
	Submenu "Masking Utilities"	
		"Make Mask", makeMask()
		"-"
		"Mask points inside marquee circle",  Maskutility(1,nan,1)
		"Mask points inside marquee box",  Maskutility(1,nan,2)
		"Unmask points inside marquee circle",Maskutility(1,1,1)
		"Unmask points inside marquee box",Maskutility(1,1,2)
		"-"
		"Mask points outside marquee circle",  Maskutility(0,nan,1)
		"Mask points outside marquee box",  Maskutility(0,nan,2)
		"Unmask points outside marquee circle",Maskutility(0,1,1)
		"Unmask points outside marquee box",Maskutility(0,1,2)
		"-"
		"Mask or unmask image",maskimage1()//maskit()
			"-"
		"Storemarquee"
		"DrawMarquee",DrawExistingAverageBox()//in gaussian_2d

	end
	submenu "Center Utilities"
	"Set up for Gaussian 2D",FindCenter()
	"Fit to 2D Gaussian",Fitto2DGaussian()
	"Show Center",DrawCenter()
	end
	submenu "Sensitivity Utilities"
		"Cleanup sensitivity image before masking first time", cleanupsens()
		"Smooth 2D Sensitivity ",Smooth2DSensitivity()
		"Make 1 and 0 images", Make1and0Images()
		
	end
			"Remove itemp waves",cleanup_Iwaves()
End

macro arearq()
	//SVAR basename= basename
	string/g basename
	string xwavename1="q"+basename+"_Avg_N_B"
	string ywavename="r"+basename+"_Avg_N_B"
	variable arq
	arq=areaxy($xwavename1,$ywavename)//,0,2e-5)
	string cmd= "Area under "+ywavename+" vs q = "+num2str(arq)
	doalert 0,cmd
end

function setupAFRLglobals()
	 DWS_GeneralPlotTool_Initialize()
	setdatafolder root:P
		string/g root:P:gsam="---",root:P:gmt,root:P:gsen,root:P:gdark,root:P:gmask,root:P:maskname
		variable/g  root:P:drop=0,root:P:redo=1, root:P:updrop=0,root:P:FlipImage=0,root:P:qmask=0,wavelengthvalue,rindex
		
	
	if (!Exists("root:P:gsdd"))		
		variable/g root:P:gsdd=127.6
	endif	
	if (!Exists("root:P:gpixelsize"))
		variable/g root:P:gpixelsize=.01307
	endif
	if (!DataFolderExists("root:Packages:SAS_Modeling"))		
		NewDataFolder/O root:Packages
		NewDataFolder/O root:Packages:SAS_Modeling
	endif
	string ListOfVariables
	string ListOfStrings
	variable i
	SetDataFolder root:Packages:SAS_Modeling					
	ListOfStrings="DataFolderName;IntensityWaveName;QWavename;ErrorWaveName;"
	ListOfVariables="UseIndra2Data;UseQRSdata;iWavesOnly;RingCenterPixel;PixelHalfWidth;AngCent;AngHW;HC;VC;MaxI;Nopnts;Orientation;fold;SectorMinPixel;SectorMaxPixel"
	ListOfVariables+=";SDD;Wavelength;Pixelsize;SmallMon;"
	for(i=0;i<itemsInList(ListOfVariables);i+=1)	
		DWS_CreateItem("variable",StringFromList(i,ListOfVariables))
	endfor		
	for(i=0;i<itemsInList(ListOfStrings);i+=1)	
		DWS_CreateItem("string",StringFromList(i,ListOfStrings))
	endfor	
	NVAR NoPnts=root:Packages:SAS_Modeling:Nopnts
	NoPnts=50
end

Window TwoD_Panel() : Panel
	PauseUpdate; Silent 1		// building window...
	DoWindow/K Image_Analysis_Panel
	NewPanel/k=1/W=(25,0,325,500)
	setupAFRLglobals()
	variable ypos=1;delayupdate
	variable qmask=root:P:qmask
	
	ypos=1
	Button LoadMPA size={40,18},pos={2,ypos},proc=DWSP_InputPanelButtonProc,title="MPA";DelayUpdate	
	Button LoadGEL size={40,18},pos={50,ypos},proc=DWSP_InputPanelButtonProc,title="GEL";DelayUpdate	
	Button LoadIMAGE size={45,18},pos={100,ypos},proc=DWSP_InputPanelButtonProc,title="image";DelayUpdate	
	Button LoadORDELLA size={50,18},pos={150,ypos},proc=DWSP_InputPanelButtonProc,title="Ordella";DelayUpdate	
	 ypos+=35
	 SetDrawEnv linethick= 3,linefgc= (0,52224,0)//green line
	DrawLine 16,YPos-5,250,Ypos-5
	SetDrawLayer UserBack
	DrawText 85,32,"Data Loaders"
	PopupMenu sampath1,pos={3,ypos},size={168,20},proc=AFRL_PopMenuProc,title="Sample"
	PopupMenu sampath1,mode=7,popvalue=root:P:gsam,value= #"DWS_FindFolderWithWaveTypes(\"root:\", 5, \"i*\", 1)"
	PopupMenu mtpath1,pos={3,ypos+24},size={190,20},proc=AFRL_PopMenuProc,title="Empty"
	PopupMenu mtpath1,mode=8,popvalue=root:P:gmt,value= #"DWS_FindFolderWithWaveTypes(\"root:\", 5, \"i*\", 1)"
	PopupMenu darkpath1,pos={3,ypos+49},size={95,20},proc=AFRL_PopMenuProc,title="Dark"
	PopupMenu darkpath1,mode=1,popvalue=root:P:gdark,value= #"DWS_FindFolderWithWaveTypes(\"root:\", 5, \"i*\", 1)"
	PopupMenu senpath1,pos={3,ypos+74},size={94,20},proc=AFRL_PopMenuProc,title="Sensitivity"
	PopupMenu senpath1,mode=1,popvalue=root:P:gsen,value= #"DWS_FindFolderWithWaveTypes(\"root:\", 5, \"i*\", 1)"
	PopupMenu maskpath1,pos={3,ypos+100},size={269,20},proc=AFRL_PopMenuProc,title="Mask"
	PopupMenu maskpath1,mode=9,popvalue=root:P:gmask,value= #"DWS_FindFolderWithWaveTypes(\"root:\", 5, \"i*\", 1)"	
	ypos+=125
	SetDrawEnv linethick= 3,linefgc= (0,52224,0)//green line
	DrawLine 16,YPos,250,Ypos	
	ypos+=10
	SetVariable drop,pos={3,ypos},size={130,18},proc=DWS_PanelSetVarProc,title="Drop pts. low"
	SetVariable drop,fSize=12,limits={0,Inf,1},value= root:P:drop
	CheckBox Maskdata, pos={140,ypos},proc=AFRL_CheckProc,title="Mask?",value=qmask
	CheckBox FlipImage, pos={140,ypos+15},proc=AFRL_CheckProc,title="Flip?",value=0
	Button MakeMask pos={200,ypos},size={85,20},proc=DWSP_InputPanelButtonProc,title="MakeMask"
      Button Hardware size={85,20},pos={200,ypos+25},proc=DWSP_InputPanelButtonProc,title="Hardware"

	Ypos+=25
ValDisplay wavelen title="Wavelength",value=root:P:wavelengthvalue
	valDisplay wavelen, pos= {185,ypos+30},size={100,18}
	SetVariable updrop,pos={3,ypos},size={130,18},proc=DWS_PanelSetVarProc,title="Drop pts. hi"
	SetVariable updrop,fSize=12,limits={0,Inf,1},value= root:P:updrop
	Ypos+=25
	SetDrawEnv linethick= 3,linefgc= (0,52224,0)//green line
	DrawLine 16,YPos,250,Ypos	
	Ypos+=20
	SetDrawLayer UserBack
	DrawText 85,ypos,"Average Data"
	CheckBox redo pos={30,ypos}, value = root:P:redo,proc=AFRL_CheckProc,title="Redo Circ Avg of Sens, Dark and MT?"
	Ypos+=30
	DrawText 15,ypos,"Sub Bkg First"
	DrawText 170,ypos,"Circ Avg First"	
	Ypos+=5
	Button CorAvg size={120,20},pos={3,ypos},proc=DWSP_InputPanelButtonProc,title="Correct then Avg";DelayUpdate
	Button AvgCor size={120,20},pos={160,ypos},proc=DWSP_InputPanelButtonProc,title="Avg then Correct";DelayUpdate
	Ypos+=28
	SetDrawEnv linethick= 3,linefgc= (0,52224,0)//green line
	DrawLine 16,YPos,250,Ypos	
	Ypos+=18
	SetDrawLayer UserBack
	DrawText 85,ypos,"Plot 1d Data"
	Ypos+=5
	Button Plotit  size={120,20},pos={3,ypos},proc=DWSP_InputPanelButtonProc,title="Plot 1d_cor_avg"
	Button Plotall size={120,20},pos={160,ypos},proc=DWSP_InputPanelButtonProc,title="Plot 1d_N_B"
	Ypos+=28
	Button AddCOR  size={120,20},pos={3,ypos},proc=DWSP_InputPanelButtonProc,title="Add 1d_cor_avg"
	Button AddNB size={120,20},pos={160,ypos},proc=DWSP_InputPanelButtonProc,title="Add 1d_N_B"
	Ypos+=35
	SetDrawEnv linethick= 3,linefgc= (0,52224,0)//green line
	DrawLine 16,YPos,250,Ypos	
	Ypos+=18
	SetDrawLayer UserBack
	DrawText 75,ypos,"Utilities for 2d Images"
	Ypos+=5
	Button Correct2d size={120,20},pos={3,ypos},proc=DWSP_InputPanelButtonProc,title="Correct raw 2d";DelayUpdate
	Button Average size={120,20},pos={3,ypos+25},proc=DWSP_InputPanelButtonProc,title="Circ Avg _cor"	
	Button Plot2d pos={160,ypos}, size={120,20},proc=DWSP_InputPanelButtonProc,title="Plot 2d image";DelayUpdate	
	Button DummyWaves pos={160,ypos+25},size={120,20},proc=DWSP_InputPanelButtonProc,title="Make 1 & 0 Waves"
	Button Azamuthal pos={3,ypos+50},size={120,20},proc=DWSP_InputPanelButtonProc,title="Azamuthal Utilities"
	Button areabutton pos={160,ypos+50},size={120,20},proc=DWSP_InputPanelButtonProc,title="Area"
	DoWindow/C  Image_Analysis_Panel
EndMacro

Function Load_Binary(rows,cols,skipbytes)
	variable rows, cols,skipbytes
	setdatafolder root:
	//execute"GBLoadWave/O " //This just gets the path to the data
	string cmd="GBLoadWave/O/B/N=wave4/T={80,80}/S=400/W=1" //\""+ fullpath+"\""
	execute cmd	
	SVAR Name2D=s_filename//getfilename(S_Filename)
	wave wave40
	Name2D=CleanupName(Name2D, 0 )
	Name2D=Name2d[0,strlen(Name2d)-5]
	string foldername="L"+Name2d
	if (DataFolderExists(foldername)!=1)
		newdatafolder $foldername
	endif	
	setdatafolder $foldername
	Redimension/N=(rows,cols) wave40
	Name2d="i"+Name2d[0,31]
	string/g basename=Name2d[1,31]
	variable/g livetime=1,transmission=1, absI=1,thickness=1//need to put in the actual exposure time
	Duplicate/o wave40, $Name2d
	killwaves wave40
	Make2DImage(Name2d, 0)
	// GBLoadWave/O/B/N=wave4/T={80,80}/S=(skipbytes)/W=1 "g4PB:Users:dws:Desktop:binary data:AL_10_S.GEL"
end 

function cleanup_Iwaves()
	string folders,activefolder
	setdatafolder root:
	folders=  IN2G_FindFolderWithWaveTypes("root:", 5, "itemp", 1)
	variable i=0
	do
		activefolder= StringFromList(i,folders)
		if( strlen(activefolder) == 0 )
			break
		endif
		setdatafolder activefolder
		wave w=$(activefolder+"itemp")
		//print activefolder+"itemp"
		killwaves/z w
		i+=1
	while(1)

	folders=  IN2G_FindFolderWithWaveTypes("root:", 5, "*_avg*", 1)
	i=0
	
	do
		activefolder= StringFromList(i,folders)
		if( strlen(activefolder) == 0 )
			break
		endif
		setdatafolder activefolder
		SVAR basename=basename
		 wave w=$(activefolder+"r"+basename+"_avg")
		killwaves/z w
		wave w=$(activefolder+"s"+basename+"_avg")
		killwaves/z w		
		wave w=$(activefolder+"q"+basename+"_avg")
		killwaves/z w
		
		wave w=$(activefolder+"s"+basename+"_avg_N")
		killwaves/z w
		 wave w=$(activefolder+"r"+basename+"_avg_N")
		killwaves/z w
		wave w=$(activefolder+"q"+basename+"_avg_N")
		killwaves/z w
	i+=1
	while(1)
end


Macro Sector_ave()
	//SetOperationFolder()
	string/g activeimage
	IF (strsearch(activeimage,"_cor",0)==-1)
		doalert 1, activeimage+"\ris not corrected data.\r\rShould Igor do the background correction?"
		if (v_flag==1)
			Correct1dor2d()
		endif
	else
		doalert 1, "The image \r"+activeimage+ "\rwill be sector averaged."
		if (v_flag==2)
			abort
		endif
	endif
	DrawSectorLineson2D();DelayUpdate
	SectorAverage2DImage("itemp",root:P:gxCenter,root:P:gyCenter, root:P:gSDD,root:P:gPixelSize,root:P:gThetaSec,root:P:gDelThS)
endmacro

Macro dividebythickness()
	SetOperationFolder()
	dividebythickness1()
EndMacro	

macro dividebythickness1(thick,absInten)
	variable/g thickness,absI
	string/g basename
	variable thick=thickness,absinten
	prompt thick,"Enter  Thickness in mm"
	Prompt absinten, "Enter absolute intensity multiplier (0.0018)"
	
	If (thickness==0)
		thickness=1
	endif
		
	If (AbsI==0)
		AbsI=1
	endif
	
	If (thickness!=0)
		doalert 1,"i*_cor, s*_N_B and r*_N_B waves will be renormalized\r Old thickness ="+num2str(thickness)+ " mm\r old absI = "+num2str(absI)
		If  (v_flag>1)
			abort
		endif
		string rNBwave,iwave,sNBwave
		//iwave="i"+basename+"_cor"
		rNBwave="r"+basename+"_avg_N_B"
		sNBwave="s"+basename+"_avg_N_B"
		$rNBwave=$rNBwave*thickness*absinten/(thick*.1*absI)
		$sNBwave=$sNBwave*thickness*absinten/(thick*.1*absI)
		$iwave=$iwave*thickness*absinten/(thick*.1*absI)
		thickness=thick
		absI=absinten
	endif
endmacro


 
Macro LoadIMAGE()
	Silent 1
	setdatafolder root:
	//ImageLoad/T=any/O/Q/N=image 	
	ImageLoad/T=tiff/O/N=image
	String Name2D,fullpath,killfile,FullName
	FullName=s_filename
	Name2D=s_filename//getfilename(S_Filename)
	killfile=s_filename
	Name2D=CleanupName(Name2D,0)
	Name2D=Name2d[0,strlen(Name2d)-5]
	
	name2D =Getnamechanges(name2D)
	Name2D=CleanupName(Name2D,0)
	
	string foldername="Y"+Name2d
	if (DataFolderExists(foldername)!=1)
		newdatafolder $foldername
	endif
	setdatafolder $foldername
	string/g OriginalFileName=Fullname
	Name2d="i"+Name2d[0,31]
	string/g basename=Name2d[1,31]
	variable/g livetime=3600,transmission=1, absI=1,thickness=10//need to put in the actual exposure time
	//variable/g xcenterlcl=100, ycenterlcl=100
	Duplicate/o root:image,$Name2d
	variable/g xcenterlcl=.5*dimsize($name2d,0)
	variable/g ycenterlcl=.5*dimsize($name2d,1)
	string text=Name2d
	getparameters(,,text,)
	killwaves root:image
	redimension/s/N=(-1,-1,0) $Name2D//convert image wave to floating point
	//Make2DImage(Name2D, 0)
		//getspecs()
endmacro

Macro LoadGEL()
	Silent 1
	setdatafolder root:
	ImageLoad/O/Q/N=image 	
	String Name2D,fullpath,killfile,FullName
	FullName=s_filename
	Name2D=s_filename//getfilename(S_Filename)
	killfile=s_filename
	Name2D=CleanupName(Name2D,0)
	Name2D=Name2d[0,strlen(Name2d)-5]
	string foldername="L"+Name2d
	if (DataFolderExists(foldername)!=1)
		newdatafolder $foldername
	endif
	setdatafolder $foldername
	string/g OriginalFileName=Fullname
	Name2d="i"+Name2d[0,31]
	string/g basename=Name2d[1,31]
	variable/g livetime=3600,transmission=1, absI=1,thickness=10//need to put in the actual exposure time
	//variable/g xcenterlcl=100, ycenterlcl=100
	Duplicate/o root:image,$Name2d
	string text=Name2d
	variable/g xcenterlcl=.5*dimsize($name2d,0)
	variable/g ycenterlcl=.5*dimsize($name2d,1)
	getparameters(,,text,)

	killwaves root:image
	redimension/s/N=(-1,-1,0) $Name2D//convert image wave to floating point
	Make2DImage(Name2D, 0)
		getspecs()
endmacro

	
Macro LoadMPA()
	Silent 1
	setdatafolder root:
	if (!DataFolderExists("root:Packages:SAS_Modeling"))		
		NewDataFolder/O root:Packages
		NewDataFolder/O root:Packages:SAS_Modeling
	endif
	variable refno=2,counter=0;string headerpart="", Header=""
	string filename,s_filename
		Open /R/T=".mpa"/m="open .mpa file"  refno as filename
		do
			FReadLine  refNo, headerpart
			Header+=headerpart
			counter+=1
		while(counter<87)
		Close refno
	String Name2D
	Name2D=getfilename(S_Filename)
	//Name2D=CleanupName(Name2D, 0)//CorrectBaseName(Name2D)
	Name2D=Name2d[0,strlen(Name2d)-5]
	Name2d=AskName(Name2d,Name2d,21)
	string foldername="X"+name2d
	
	if (DataFolderExists(foldername)!=1)
		newdatafolder $foldername
	endif
	setdatafolder $foldername
	LoadWave/G/Q/O/A=Georg/K=0/L={0,(2156),0,0,0} s_filename
	Name2d="i"+Name2d
	duplicate/o georg0 $name2d
	//make/o/n=(numpnts(georg0))$Name2D
	Redimension/N=(1024,1024) $Name2D
	Killwaves Georg0, georg1
	note $Name2d,header
	variable/g realtime=GetTimeFromMPAHeader($Name2D,"realtime")
	variable/g livetime=GetTimeFromMPAHeader($Name2D,"livetime")
	string text=Name2d
	variable/g xcenterlcl=.5*dimsize($name2d,0)
	variable/g ycenterlcl=.5*dimsize($name2d,1)
	getparameters(,,text,)
	string/g basename=Name2d[1,100]
	//DoAlert 1,"Plot 2d data?"
	//if(v_Flag==1)
	Make2DImage(Name2D, 0)
//	endif
EndMacro
	
	
Function GetTimeFromMPAHeader(Name2D,timetype)
	wave Name2D
	string timetype
	variable value
	
	silent 1
	string header=note(Name2D)
	variable postime=strsearch(header,(timetype+"="),0)
	value= str2num(header[9+postime,(18+Postime)])
	postime=strsearch(header,(timetype+"="),Postime+18)
	value+= str2num(header[9+postime,(18+Postime)])

	return value/2
End


Macro ConvertqtoAngle(Xa)
	string/g xvalue
	string xa=xvalue
	Prompt Xa,"Enter the q-wave to convert:",popup,WaveList("q*", ";", "")
	Silent 1
	
	xvalue=xa
	string rwave="r"+xvalue[1,31], swave="s"+xvalue[1,31]
	string qang="q"+xvalue[1,26]+"_ANG"
	string rang="r"+xvalue[1,26]+"_ANG",sang="s"+xvalue[1,26]+"_ANG"
	duplicate $rwave, $rang
	duplicate $swave, $sang
	duplicate $xa, $qang
	$qang= 180*2*asin(1.54*$qang/(4*pi))/pi
	print qang+" converted to 2 theta"
	ConvertqtoAngle()
EndMacro




Function SectAverageName2DGeorg(Name2D,qout,rout,sout,NOut,xcenter,ycenter,TS,DTS)
	wave Name2D,qout,rout,sout,NOut
	variable xcenter,ycenter,TS,DTS
	
	//Get width and height
	Wavestats/Q Name2D
	variable xwidth=Dimsize(Name2D,0)
	variable yheight=Dimsize(Name2D,1)
	nvar gtopcut=root:P:gTopCut,gbottomcut=root:P:gBottomCut,gleftcut=root:P:gLeftCut,grightcut=root:P:gRightCut
	//Get rarray 
	if(waveexists(Rvalues2D)==1)
		killwaves Rvalues2D
	endif
	if(waveexists(ThetaValues2D)==1)
		killwaves ThetaValues2D
	endif
	duplicate Name2D Rvalues2D
	duplicate Name2D ThetaValues2D
	Rvalues2D=round(sqrt((x-xcenter)^2+(y-ycenter)^2))
	SetThetaValues(ThetaValues2D,xcenter,ycenter)

	variable maxchannel=round(sqrt((xcenter-gleftcut)^2+(ycenter-gbottomcut)^2))
	if(round(sqrt((grightcut-xcenter)^2+(ycenter-gbottomcut)^2))>=maxchannel)
		maxchannel = round(sqrt((grightcut-xcenter)^2+(ycenter-gbottomcut)^2))
	endif
	if(round(sqrt((xcenter-gleftcut)^2+(gtopcut-ycenter)^2))>=maxchannel)
		maxchannel = round(sqrt((xcenter-gleftcut)^2+(gtopcut-ycenter)^2))
	endif
	if(round(sqrt((grightcut-xcenter)^2+(gtopcut-ycenter)^2))>=maxchannel)
		maxchannel = round(sqrt((grightcut-xcenter)^2+(gtopcut-ycenter)^2))
	endif
	//Make the output waves spaced at one channel
	Redimension/N=(maxchannel+1) qout,rout,nout,sout
	qout=p;rout=0;sout=0;nout=0
	//Get Max and min theta for sector in Radians
	variable TMin=(TS-DTS)*pi/180,TMax=(TS+DTS)*pi/180
	//If TMin is <0 you need to deal with out of quadrant things,
	//also if Tmax is > 180
	variable xcount=gleftcut,ycount=gbottomcut
	If((TMin<0)|(TMax>pi))	//Then do one routine
		If(TMin<0)
			//Here you sum for theta<=TMax or >=pi+TMin (assumes theta is positive)
			//Go through the array placing the intensity where it goes, spaced at one channel
			do
				do
					//Sum only if you are in the right range of theta (for sector average)
					if((ThetaValues2D(xcount)(ycount)>=(pi+TMin))|(ThetaValues2D(xcount)(ycount)<=TMax))
						if(ThetaValues2D(xcount)(ycount)<0)
							//print "houston we have a problem"
						endif
						rout[(Rvalues2D(xcount)(ycount))]+=Name2D(xcount)(ycount)
						Nout[(Rvalues2D(xcount)(ycount))]+=1
					endif
					xcount+=1
				while(xcount<grightcut)
				xcount=0
				ycount+=1
			while(ycount<gtopcut)	
		else// TMax has to be >180 here
			//Here you sum for theta<=TMax-pi/2 or >=TMin (assumes theta is positive)
			//Go through the array placing the intensity where it goes, spaced at one channel
			do
				do
					//Sum only if you are in the right range of theta (for sector average)
					if((ThetaValues2D(xcount)(ycount)>=TMin)|(ThetaValues2D(xcount)(ycount)<=(TMax-pi/2)))
						if(ThetaValues2D(xcount)(ycount)<0)
							print "Houston we have a problem"
						endif
						rout[(Rvalues2D(xcount)(ycount))]+=Name2D(xcount)(ycount)
						Nout[(Rvalues2D(xcount)(ycount))]+=1
					endif
					xcount+=1
				while(xcount<grightcut)
				xcount=0
				ycount+=1
			while(ycount<gtopcut)	
		endif
	else	//Then do another routine Here TMin and TMax are as defined, i.e. they both are in quadrants 1 or 2
		//Go through the array placing the intensity where it goes, spaced at one channel
		do
			do
				//Sum only if you are in the right range of theta (for sector average)
				if((ThetaValues2D(xcount)(ycount)>=TMin)%&(ThetaValues2D(xcount)(ycount)<=TMax))
					if(ThetaValues2D(xcount)(ycount)<0)
						print "Houston we have a problem"
					endif
					rout[(Rvalues2D(xcount)(ycount))]+=Name2D(xcount)(ycount)
					Nout[(Rvalues2D(xcount)(ycount))]+=1
				endif
				xcount+=1
			while(xcount<grightcut)
			xcount=0
			ycount+=1
		while(ycount<gtopcut)	
	endif
	
	//Remove the q=0 point
	DeletePoints 0,1,qout,rout,sout,nout
	
	//Now get error and normalize rout
	sout=sqrt(rout)/Nout
	rout=rout/Nout
	killwaves Rvalues2D,ThetaValues2D,Nout
End

Function SetThetaValues(TV2D,xc,yc)
	wave TV2D
	variable xc,yc
	
	nvar topcut=root:P:gTopCut,bottomcut=root:P:gBottomCut,LeftCut=root:P:gLeftCut,rightcut=root:P:gRightCut
	//sector 1
	TV2D[xc,rightcut][yc,topcut]=pi/2-asin((y-yc)/(round(sqrt((x-xc)^2+(y-yc)^2))))
	//sector 2
	TV2D[xc,rightcut][bottomcut,yc-1]=pi/2+asin((y-yc)/(round(sqrt((x-xc)^2+(y-yc)^2))))
	//sector 3
	TV2D[leftcut,xc-1][bottomcut,yc-1]=pi/2-asin((yc-y)/(round(sqrt((x-xc)^2+(y-yc)^2))))
	//sector 4
	TV2D[leftcut,xc-1][yc, topcut]=pi/2+asin((y-yc)/(round(sqrt((x-xc)^2+(y-yc)^2))))
End


//	variable/g gsamI0,gsamtime,gsamdctime,gMtI0,gmttime,gmtdctime,gsentime,gsendctime
//  	variable/g gqoutputname
//	string/g gsam, gsamdc,gmt,gmtdc,gsen, gsendc, goutputbase

Macro RadialAverageSemensData(Matrix,nopnts,OutBase,qAutoName,Mtop)
	String/g root:P:gMatrix,root:P:goutbase
	variable/g root:P:gnopnts,root:P:gqAutoName,root:P:gmtop
	String Matrix=root:P:gMatrix,outbase=root:P:goutbase
	variable nopnts=root:P:gnopnts,qAutoName=root:P:gqAutoName,mtop=root:P:gmtop
	Prompt matrix,"Siemens 2D data set:",popup,WaveList("*", ";", "")
	Prompt nopnts,"Number of points in output: (250)"
	prompt outbase,"Output Base Name:"
	prompt qAutoName,"Auto Name Output?",popup,"Yes;No"
	Prompt mtop,"Where is the Marquee?",popup,"Top;Left"
	
	silent 1
	root:P:gqAutoName=qAutoName;root:P:gmtop=mtop
		variable/g root:P:gxcenter,root:P:gycenter
	variable xcenter=root:P:gxcenter,ycenter=root:P:gycenter
		print "Center is x = "+num2str(xcenter)+" y = "+num2str(ycenter)
	if(qAutoName==1)
		outbase=Matrix
	endif
	string rname="R"+outbase[0,24]+"_Rad",qname="Q"+outbase[0,24]+"_Rad",sname="S"+outbase[0,24]+"_Rad"
	if(waveexists($rname))
		killwaves $rname
	endif
	if(waveexists($qname))
		killwaves $qname
	endif
	if(waveexists($sname))
		killwaves $sname
	endif
	root:P:gMatrix=Matrix;root:P:gnopnts=nopnts;root:P:goutbase=outbase
	string wavenote=note($Matrix)
	//variable start=GetStartPos(wavenote,"\r",54)
	//print "Center of "+matrix+" is: HC= "+wavenote[start+9,start+22]+", VC= "+wavenote[start+24,start+36]
	RadialAverage($Matrix,nopnts,mtop)
	note qwave,wavenote
	note rwave,wavenote
	note swave,wavenote
	string addedstring="Radial Average"
	variable root:P:top, root:P:bottom, root:P:left, root:P:right
	if(mtop==1)
		addedstring+="/rTop Box: top "+num2str(root:P:top)+": bottom "+num2str(root:P:bottom)
	else
		addedstring+="/rLeft Box: left "+num2str(root:P:left)+": right "+num2str(root:P:right)
	endif
	note qwave,addedstring
	note rwave,addedstring
	note swave,addedstring
	rename rwave $rname
	rename qwave $qname
	rename swave $sname
	//rename nwave "n"+outbase  //just use the same nwave since you don't need this...
	//Q is now in point number from the center
EndMacro

Function RadialAverage(Matrix,nopnts,mtop)
	wave matrix
	variable nopnts,mtop
	//Need to use x values rather than p values since y index is reversed
	
	Print "THIS WILL TAKE 1 MINUTE FOR 1024 DATA SET ON A POWER MAC"
	variable matrixtype=wavetype(matrix)
	make/o/n=(nopnts) qwave=0,Nwave=0,rwave=0,swave=0
	string Header=note(matrix)
	//variable start=GetStartPos(header,"\r",41),oldstart=GetStartPos(header,"\r",40)
	//variable ncols=str2num(header[start+9,start+19]),nrows=str2num(header[oldstart+9,oldstart+19])
	variable ncols=1024,nrows=1024
	variable NumPts=(nrows)*(ncols)//the index only goes to 1023  counters start at 0
	variable counterA=0,counterB=0,Vert=0,Hor=0
	//start=GetStartPos(header,"\r",54)
	//variable HC=str2num(header[start+9,start+22]),VC=str2num(header[start+24,start+36])
	//variable/g root:P:gxcenter,root:P:gycenter
	nvar HC=root:P:gxcenter,VC=root:P:gycenter
	//***new for radial
//calculate the radial distances to integrate over
	variable RadMax,RadMin
	nvar top= root:P:ggtop,bottom=root:P:ggbottom,right=root:P:ggright,left=root:P:ggleft
	if(mtop==1)//then this is a top marquee
		RadMax=abs(top-VC)
		RadMin=abs(bottom-VC)
	else//this is a left marquee
		RadMax=abs(left-HC)
		RadMin=abs(right-HC)
	endif
	
	//***get the q wave in Degrees
	variable Anglestepsize=360/(NoPnts-1),AnglePos=0//Zero is top dead center...Goes Clockwise
	variable radpos=0
	//Make the angle wave
	qwave=p*Anglestepsize
	//integrate the angle bins
	do
		Vert=Trunc(CounterA/nrows)
		Hor=CounterA-Vert*nrows
		RadPos=sqrt((hor-HC)^2+(Vert-VC)^2)
		//Bin the data for data in the radial range
		if((radpos>=RadMin)%&(radpos<=RadMax))//In the radial range?
			//Calculate the angle for this data point for each of 4 quardarants so 4 possibilities
			do
				if(((hor-HC)>=0)%&((Vert-VC)>=0))//both positive or both 0
					AnglePos=90-180*atan((Vert-VC)/(hor-HC))/Pi
					break
				endif
				if(((hor-HC)>0)%&((Vert-VC)<0))//H positive Vnegative
						AnglePos=90+180*atan(abs((Vert-VC)/(hor-HC)))/Pi
					break
				endif
				if(((hor-HC)<0)%&((Vert-VC)>0))//V positive H negative
					AnglePos=270+180*atan(abs((Vert-VC)/(hor-HC)))/Pi
					break
				endif
				//both negative
				AnglePos=270-180*atan(abs((Vert-VC)/(hor-HC)))/Pi
				break
			while(1)
			//not bin according to the angle
			Nwave[(round(AnglePos/Anglestepsize))]+=1
			Rwave[(round(AnglePos/Anglestepsize))]+=matrix(hor)(vert)
		endif
		counterA+=1
	while(counterA<(numpts))
	Swave=sqrt(Rwave[p])/Nwave[p]
	Rwave/=Nwave[p]
	counterB=0
End

Macro ReadAName(Name)
	string/g root:P:gName
	string Name=root:P:gName
	Prompt Name,"Data Set"+num2str(root:P:gno+1)+"to Average:",popup,WaveList("i*", ";", "")
	
	silent 1
	root:P:gname=name
EndMacro

macro Normalize()
	setdatafolder root:
	SubtractDCandNormalize()
endmacro

Macro SubtractDCandNormalize(sampath,darkpath,senpath)//corrects for sensitivity and transmission. 
	string/g root:P:gsam,root:P:gdark,root:P:gsen
	string sampath=root:P:gsam,darkpath=root:P:gdark,senpath=root:P:gsen
	Prompt sampath,"Sample: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt senpath,"Sensitivity: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt darkpath,"Dark: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	
	setdatafolder sampath
	root:P:gsam=sampath;root:P:gdark=darkpath;root:P:gsen=senpath
	//sampath=sampath+":";darkpath=darkpath+":";senpath="root:"+senpath+":"
	string basename=$(sampath+"basename")
	string sample=sampath+"r"+($(sampath+"basename"))+"_avg"
	string sen=senpath+"r"+($(senpath+"basename"))+"_avg"
	string dark=darkpath+"r"+($(darkpath+"basename"))+"_avg"
	string senerror=senpath+"s"+($(senpath+"basename"))+"_avg"
	string darkerror=darkpath+"s"+($(darkpath+"basename"))+"_avg"
	variable transmission=$(sampath+"transmission")
	variable darktime=$(darkpath+"livetime"),livetime=$(sampath+"livetime"),sentime=$(senpath+"livetime")
	string rout="r"+basename[0,29]+"_avg_N",qout="q"+rout[1,100], sout="s"+rout[1,100]	
	make/o/n=(numpnts($sample)) $Rout
	//gets average of sensitivity.  Be sure sensitivity rwave_avg is masked 

			WaveStats/q $sen
	variable a=v_avg//average of sensistivity rwave
	//print "average sensitivity  = "+num2str(a)+" counts/pixel"
	a=a*3600/sentime
	print "average sensitivity  = "+num2str(a)+" counts/omega/hour"
	if (numtype(a)!=0)
		Doalert 0, "Sensitivity normalization constant, a = NaN\rIgor can't proceed.\rHave you entered machine parameters using getspecs()?"
		abort
	endif
	string qsam=sampath+"q"+basename+"_avg"
	string samerror=sampath+"s"+basename+"_avg"
	Duplicate/O$qsam,$qout
	duplicate/O $samerror, $sout
	//_avg is  counts/pixel

	$Rout=(a/transmission)*(($sample/livetime)-($dark/darktime))/(($sen/sentime)-($dark/darktime))
//avgwave may not exist.

	$Sout=(($samerror/livetime)+($darkerror/darktime))/(($sen/sentime) -($dark/darktime))
	
	//$Sout+=(($sample/livetime)-($dark/darktime))*(($senerror/sentime)+($darkerror/darktime))/((($sen/sentime)-($dark/darktime))^2)
		$Sout*=(a/transmission)
	//($dark/darktime)*($darkerror/darktime)/($sen/sentime)^2
	//results are in counts/pixel/hour
Endmacro

Macro ReplaceAvgforLine(Name2D,X1,Y1,X2,Y2,LW,qreplace)
	string/g gName2D
	variable/g gX1,gY1,gX2,gY2,gLW
	variable X1=gX1,Y1=gY1,X2=gX2,Y2=gY2,LW=gLW
	string Name2D=gname2d
	variable top=gtop,left=gleft,bottom=gbottom,right=gright,qreplace=gqreplace
	Prompt Name2D,"Enter the Sensitivity Wave to Smooth",popup,WaveList("0*", ";", "")
	Prompt X1,"Enter X1 for line: (597)"
	Prompt Y1,"Enter Y1 for line: (536)"
	Prompt X2,"Enter X2 for line: (983)"
	Prompt Y2,"Enter Y2 for line: (255)"
	Prompt LW,"Enter the width of the line:(30)"
	Prompt qreplace,"Make a New wave with result?",popup,"No;Yes"
	
	Silent 1
	gX1=X1;gY1=Y1;gX2=X2;gY2=Y2;gLW=LW;gqreplace=qreplace;gName2D=Name2D
	string newname=Name2D[0,26]+"_RPL"
	if(qreplace==2)
		if(waveexists($newname))
			Print "Overwriting existing wave"
		else
			duplicate $name2D,$newname
		endif
	else
		newname=Name2D
	endif
	ReplaceLine($newname,X1,Y1,X2,Y2,LW)
Endmacro

Function ReplaceLine(NN,X1,Y1,X2,Y2,LW)
	wave NN
	variable X1,Y1,X2,Y2,LW
	
	//Calculate K1 and K2 for the Line Y=k1 x + k2, k1 = (y2-y1)/(x2-x1)
	variable K1=(Y2-Y1)/(X2-X1), K2 = Y2 - K1*X2
	
	//go to line above and  below and get average value
	variable MV=0,counter=0
	//Scan x and do stripes half above and half below
	
	variable ycounter=Y1,xcounter=X1
	variable ytop,ybottom
	do//go across y stripes for each x
		//do top
		ycounter=K1*xcounter+K2+LW/2+1
		do
			MV+=NN[xcounter][ycounter]
			counter+=1
			ycounter+=1
		while(ycounter<=K1*xcounter+K2+LW+1)
		
		//do bottom
		ycounter=K1*xcounter+K2-LW/2-1
		do
			MV+=NN[xcounter][ycounter]
			counter+=1
			ycounter-=1
		while(ycounter>=K1*xcounter+K2-LW-1)
		ytop=K1*xcounter+K2+LW/2
		ybottom=K1*xcounter+K2-LW/2
		NN[xcounter][ybottom,ytop]=MV/counter
		//One stripe done
		counter=0
		MV=0
		xcounter+=1
	while(xcounter<=X2)
End

Macro ReplaceAvgforSquare(Name2D,Top,Left,Bottom,Right,qreplace)
	string/g gName2D
	variable/g gtop,gleft,gbottom,gright,gqreplace
	string Name2D=gname2d
	variable top=gtop,left=gleft,bottom=gbottom,right=gright,qreplace=gqreplace
	Prompt Name2D,"Enter the Sensitivity Wave to Smooth",popup,WaveList("0*", ";", "")
	Prompt Top,"Enter top of box:"
	Prompt left,"Enter left of box:"
	Prompt bottom,"Enter bottom of box:"
	Prompt right,"Enter right of box:"
	Prompt qreplace,"Make a New wave with result?",popup,"No;Yes"
	
	Silent 1
	gtop=top;gbottom=bottom;gleft=left;gright=right;gqreplace=qreplace;gName2D=Name2D
	string newname=Name2D[0,27]+"_RP"
	if(qreplace==2)
		if(waveexists($newname))
			Print "Overwriting existing wave"
		else
			duplicate $name2D,$newname
		endif
	else
		newname=Name2D
	endif
	ReplaceBox($newname,top,bottom,left,right)
Endmacro

Function ReplaceBox(NN,TP,BT,LT,RT)
	wave NN
	variable TP,BT,LT,RT
	
	//go to box above and box below and get average value
	variable xdiff=RT-LT,ydiff=TP-BT,MV=0,counter=0
	//Scan x and do stripes
	variable ycounter=TP+1,xcounter=LT
	do//go across y stripes for each x
		//do top
		ycounter=TP+1
		do//does positive y
			MV+=NN[xcounter][ycounter]
			counter+=1//keeps track of total points added in for normalization
			ycounter+=1
		while(ycounter<=TP+1+ydiff/2)
		//do bottom
		ycounter=BT-1
		do//negative y
			MV+=NN[xcounter][ycounter]
			counter+=1
			ycounter-=1
		while(ycounter>=BT-1-ydiff/2)
		NN[xcounter][BT,TP]=MV/counter//y is averaged over a range
		//One stripe done
		counter=0
		MV=0
		xcounter+=1
	while(xcounter<=LT+xdiff)
End

Macro Smooth2DSensitivity(Name2D,AW,AS,XW,leftcut,rightcut,topcut,bottomcut)
	variable/g root:P:gTopCut,root:P:gBottomCut,root:P:gLeftCut,root:P:gRightCut
	variable/g root:P:gAW,root:P:gAS,root:P:gXW
	variable AW=root:P:gAW,AS=root:P:gAS,XW=root:P:gXW
	variable TopCut=root:P:gTopCut,BottomCut=root:P:gBottomCut,LeftCut=root:P:gLeftCut,RightCut=root:P:gRightCut
	string Name2D
	Prompt Name2D," Sensitivity Wave to Smooth",popup,WaveList("i*", ";", "")
	Prompt AW,"Pixels to average:(5)"//Pixels up and down (y-axis will be used as image shows
												   //streaks on the y axis
	Prompt AS,"Enter Sigma:(1; 1e6 no Gaussian)"//If 1e6 No Gaussian Weight
	Prompt XW,"Enter the x-width of the smooth:(1)"
	Prompt LeftCut,"Enter Point from Left to Ignore:(60)"
	Prompt RightCut,"Enter Point from Right to Ignore:(970)"
	Prompt TopCut,"Enter Point from Top to Ignore:(980)"
	Prompt BottomCut,"Enter Point from Bottom to Ignore:(60)"
	
	Silent 1
	PauseUpdate
	root:P:gAW=AW;root:P:gAS=AS;root:P:gXW=XW
	root:P:gTopCut=TopCut;root:P:gBottomCut=BottomCut;root:P:gLeftCut=LeftCut;root:P:gRightCut=RightCut
	string newname=Name2D[0,27]+"_SM"
	if(waveexists($newname))
		Print "Overwriting existing wave"
	else
		duplicate $name2D,$newname
	endif
	$Newname=0
	Smooth2D($name2D,$newname,TopCut,BottomCut,LeftCut,RightCut,AW,AS,XW)	
Endmacro
	
Function Smooth2D(N2D,NN,TC,BC,LC,RC,AW,AS,XW)
	Wave N2D,NN
	variable TC,BC,LC,RC,AW,AS,XW
	
	variable countery=BC+AW,counterx=LC+AW,ycountersum=0,wt=0,ypos=0,sumwt=0,xpos=0
	do
		do
			do
				ypos=countery+ycountersum-AW
				//USE a Gaussian Weight in y axis and x axis
				xpos=counterx-trunc(XW/2)
				do//go through xwidth
					wt=exp(-((ypos-countery)^2+(xpos-counterx)^2)/(AS)^2)
					sumwt+=wt
					NN[counterx][countery]+=wt*N2D[counterx][countery+ycountersum-AW]
					xpos+=1
				while(xpos<counterx+trunc(XW/2))
				ycountersum+=1
			while(ycountersum<2*AW+1)
			ycountersum=0
			NN[counterx][countery]/=sumwt	 //AW*2+1
			sumwt=0
			counterx+=1
		while(counterx<=RC-AW)
		counterx=0
		countery+=1
		print "countery ="num2str(countery)
	while(countery<=TC-AW)
End

function Make1and0images()
	SVAR sam= root:P:gsam
	if (cmpstr(sam,"---")==0 || strlen(sam)<=0)
		Abort "Sample image must be selected"
	endif
	variable ximagesize,yimagesize
	String savedDF= GetDataFolder(1)	
	SVAR df=root:P:gsam
	setdatafolder df
	SVAR basen=basename
	string sample=df+"i"+basen
	yimagesize=DimSize($sample, 0 )
	ximagesize=DimSize($sample, 1)
	setdatafolder root:
	string ending="_"+num2str(ximagesize)+"_"+num2str(yimagesize)
	string foldername="Xunityimage"+ending
	newdatafolder/o/s $foldername
	variable/g xcenterlcl=ximagesize/2
	variable/g ycenterlcl=yimagesize/2
	sample="iunityimage"+ending
	make/o/n=(ximagesize,yimagesize) $sample=1
	SetupFolder()	
	setdatafolder root:
	foldername="Xzeroimage"+ending
	newdatafolder/o/s $foldername
	sample="izeroimage"+ending
	make/o/n=(ximagesize,yimagesize) $sample=0
	variable/g xcenterlcl=ximagesize/2
	variable/g ycenterlcl=yimagesize/2
	SetupFolder()
	variable/g root:P:gvalue0=0
	SetDataFolder savedDF	
end
	
Function SetupFolder()
	string name=GetDataFolder(0)
	string/g basename=name[1,100]
	variable/g transmission =1,livetime=1	
end

function GetSpecs()	
	NVAR    HC=root:Packages:SAS_Modeling:HC
	NVAR    VC=root:Packages:SAS_Modeling:VC
	NVAR gSDD=root:P:gSDD
	NVAR gpixelsize=root:P:gPixelSize
	variable xcenter=HC,ycenter=VC, pixelsize= gpixelsize,wavel,SDD=gSDD,temp,index
	SVAR gSam=root:P:gsam
	NVAR gWavelengthvalue=root:P:wavelengthvalue
	NVAR rindex=root:P:rindex
	SDD=gSDD;PixelSize=gPixelSize;index=rindex
 		If (gWavelengthvalue==6328)
 			WaveL=1
 		elseif (gWavelengthvalue==1.54)
 			WaveL =2	
 		elseif (gWavelengthvalue==5330)
 			WaveL =3		
 		elseif (gWavelengthvalue==1.042)
 			WaveL =4
 		endif
	Prompt xcenter,"Global and local xCenter:(522)"
	Prompt ycenter,"Global and local yCenter:(489)"
	Prompt SDD,"Sam. to Det. Distance:(127.6cm)"
	Prompt PixelSize,"Pixel Size:(12cm/911=0.01317)"
	Prompt Wavel,"Wavelength ", popup, "6328;1.54;5330;1.042"
	Prompt index, "Rrefractive index"
	doprompt  "Hardware",xcenter,ycenter,SDD,PixelSize,Wavel,index	
	gSDD=SDD;Rindex=index
	NVAR xcenterlcl;NVAR  ycenterlcl
	xcenterlcl=xcenter; ycenterlcl=ycenter
	HC=xcenter;VC=ycenter
	gpixelsize=pixelsize
	
 	switch(wavel)
 		case 1:		
 			gWavelengthvalue=6328
 			break
 		case 2:		
 			gWavelengthvalue=1.54	
 			break
 		case 3:						
 			gWavelengthvalue=5330
 			break
 		case 4:
 			gWavelengthvalue=1.042		
 	endswitch
Endmacro

Proc OpenAllTextFilesinFolder(qavg,qkill,filetype)
	variable/g gqavg,gqkill,gFileType
	variable qavg=gqavg,qkill=gqkill,filetype=gfiletype
	Prompt qavg,"Average File after Read?",popup,"Yes;No"
	Prompt qkill,"Kill 2D after Averaging?",popup,"Yes;No"
	Prompt filetype,"FileType:",popup,"Normal Save;Auto Save;Kratky mpa file"

	Silent 1
	gqkill=qkill;gqavg=qavg;gfiletype=filetype
	if(qavg==1)//then get the specs for averaging
		variable/g gxCenter,gyCenter,gSDD,gPixelSize
		variable/g gTopCut,gBottomCut,gLeftCut,gRightCut
		GetAvgSpecsForRead()
	endif
	String pathName,fileName,cleanFileName,fullname
	variable index=0,refno=2
	NewPath/o/Q temporaryPath
	pathName="temporaryPath"
	String/g gName2D
	variable counter
	string header, headerpart
	string filesuffex
	variable skipfile=0
	variable counterK=0
	string dummyname="georg0"
	do
		fileName=IndexedFile($pathName, index, "????")
		Print " "
		if (strlen(fileName)==0)
			Beep;beep
			break
		endif
		Print "The file "+filename+" is being loaded..."
		Beep
		gFileName=fileName
		pathinfo temporarypath
		fullname=s_path+filename
		if(filetype==1)//Old Style short header
			LoadWave/J/A=Georg/K=0/L={0,36,0,0,0} fullname
		else//Autosave filetype with big header This is an MPA File
		if(filetype==2)
			filesuffex=fullname[strlen(fullname)-3,strlen(fullname)-1]
			if(cmpstr(filesuffex,"mpa")==0)
				LoadWave/J/A=Georg/K=0/L={0,(2050+87),0,0,0} fullname
			
				//get header
				Open /R refno  as fullname
				do
					FReadLine  refNo, headerpart
					Header+=headerpart
					counter+=1
				while(counter<87)
				Close refno
				//print header
				note georg0, header
			else //A Text File like transmissions
				//Could write a procedure to do this for the transmission files...
				skipfile=1	
				print "this is a "+filesuffex+" file so is not being loaded"
				beep
			endif
		else//Kratky File
			headerpart=""
			Header=""
			counterK=0
			//Open/T=".mpa"/R/D/M="Open which MPA file?" refno
			//string/g s_filename
			dummyname="georg0"
			filename=fullname//USE FULLNAME HERE
			if(waveexists($dummyname))
				killwaves $dummyname
			endif
			//Read Header
			Open /R refno  as filename
			do
				FReadLine  refNo, headerpart
				Header+=headerpart
				counterK+=1
				print headerpart  //(counterK<80)%//
			while((cmpstr(headerpart[0,12],"[DATA1,1024 ]"))!=0)  //Should happen at 68
			Close refno
			LoadWave/A=Georg/J/D/K=0/V={"\t, "," $",0,0}/L={0,(counterK),0,0,0} Fullname//s_filename
			String/g gName1D
			gName1D=S_Filename
			gName1D=CorrectoBaseaNameo(gName1D)
			//GetName1()
			Print "Opened the wave:  "+gName1D
			beep
			if(waveexists($gName1D))
				killwaves $gName1D
			endif
			rename georg0 $gName1D
			note $gName1D,header
			skipfile=1
		endif	
		endif
		
		if(skipfile==0)
			gName2D=S_Filename
			gName2D=CorrectoBaseaNameo(gName2D)
			GetName2() //Use this if you want to change the wave name
			gName2D=gName2D[0,30]
			rename georg0 $gName2D
			Redimension/N=(1024,1024) $gName2D
			if(qavg==1)//Average using parameters above
				OnReadAverage2DImage(gName2D)
			endif
			if(qkill==1)
				killwaves $gName2D
			endif
		endif
		skipfile=0
		INDEX+=1
	while(1)
	KillPath temporaryPath
End


Function AverageName2D(Name2D,qout,rout,sout,NOut,xcenter,ycenter,xwidth,yheight,numpts)
	wave Name2D,qout,rout,sout,NOut
	variable xcenter,ycenter,xwidth,yheight,numpts
	
	variable xval,yval,ycounter,hoho,cx,cy,endx,endy
	variable rval,starty,finy,counter,stepsz,otherx
	variable xcounter,outputval
	cx=xCenter
	cy=yCenter
	stepsz=sqrt((cx-xwidth)^2+(cy-yheight)^2)/numpts
	yval=0
	xval=0
	counter=0
	rval=stepsz
	counter=0
		//for rval:=1 to round(sqrt((cx-endx)^2+(cy-endy)^2)) do begin
	counter=1
		//for counter:=1 to numpts do begin
	do
						//{This is the main loop where r is changed, counter is the final result counter}
						//{next line is set to beep every 10 output points it gets slower as you go further}
		if (counter/10==trunc(counter/10))
			beep
		endif
			//{set the position for the result value counter}
		qout[counter]=stepsz*counter+stepsz/2
		rval=stepsz*counter
			//{Set the intensity and number counted to 0 before summing channels}
		rout[counter]=0
		NOut[counter]=0
			//{do x first as image is narrow x is xcounter I think}
		xcounter=round(cx-rval)
		do
				// xcounter=round(cx-rval) to round(cx-stepsz/2) do begin 
			otherx=round(2*cx-xcounter)
				//{This is the range of x where you can have a radius of rval  stepsz/2}
				//{then do y, for a given value of x there are only some y's with this rval i.e. use circle eq}
				//{first group of y's are calculated from y = sqrt((rval-stepsz/2)^2-(xcounter-cx)^2)+cy}
				//{putmessage(cy:6:2, rval:6:2,stepsz:8:2,xcounter:8:2, cx:8:2);}
				//{below corrects a rounding error}
				//{putmessage(rval:6:2,(rval+stepsz):6:2,(xcounter-cx):8:2);}
			if ((rval^2)<(xcounter-cx)^2)
				rval=abs(xcounter-cx)
			endif
				//{putmessage(rval:6:2,(rval+stepsz):6:2,(xcounter-cx):8:2);}
			starty=round(cy+sqrt((rval^2)-(xcounter-cx)^2))
				//{putmessage(rval:6:2,(xcounter-cx):8:2);}
			finy=round(cy+sqrt((rval+stepsz)^2-(xcounter-cx)^2))
				//{putmessage(starty:8:2,finy:8:2);}
				//for ycounter=starty to finy do begin
			ycounter=starty
			do
				NOut[counter]=NOut[counter]+1
				rout[counter]=rOut[counter]+Name2D(xcounter)(ycounter)
					//{putmessage(counter:6:2,getpixel(xcounter)(ycounter):8:2,$rOut[counter]:8:2);}
					//{For other size of center}
				NOut[counter]=NOut[counter]+1
				rOut[counter]=rOut[counter]+Name2D(otherx)(ycounter)
					//{for second set of y, i.e. below x axis}
				if  (ycounter!= 0)// then begin
					NOut[counter]=NOut[counter]+1
					rOut[counter]=rOut[counter]+Name2D(xcounter)(-ycounter)
						//{for the other side of center}
					NOut[counter]=NOut[counter]+1
					rOut[counter]=rOut[counter]+Name2D(otherx)(-ycounter)
				endif
				ycounter+=1
 	 		While (ycounter<=finy)  //end;
				//{putmessage(counter:6:2,rUser1[counter]:8:2,$rOut[counter]:8:2,$NOut[counter]:8:2);}
				//{putmessage(counter:6:2,$qout[counter]:8:2,$rOut[counter]:8:2,$NOut[counter]:8:2);}
			xcounter+=1
		While(xcounter<=round(cx-stepsz/2))//end
		counter+=1
	While(counter<=numpts)

		//for counter:=1 to numpts do begin
	counter=1
	do
		if (NOut[counter]==0)// then begin
			sOut[counter]=sqrt(rOut[counter])
		else //begin
			sOut[counter]=sqrt(rOut[counter])/NOut[counter]
			rOut[counter]=rOut[counter]/NOut[counter]
		endif
		counter+=1
	while(counter<=numpts)//end;
End

function Maskimage(yes)
	variable yes
	SVAR Activeimage
	SVAR maskname=root:P:maskname
	IF (stringmatch (maskname,""))
		abort "Mask does not exist"
	endif
	wave maskwave=$maskname
	wave activeimagewave=$activeimage
	wave itemp
	NVAR qlog=root:Packages:Convert2Dto1D:qlog
	NVAR qmask=root:P:qmask
	itemp=activeimagewave
	If (!waveexists($activeimage))
			Doalert 0, "No active image plot exists"
			abort
	endif
	If( qlog==1)
		itemp=log(itemp)
	endif
	if (yes)
		If (!waveexists(maskwave))
			Doalert 0, "Mask does not exist"
			abort
		endif
		itemp=(itemp*maskwave)
		qmask=1		
	else
		qmask=0
	endif
end	
		
		
macro Average2d(Samplefolder)
	string Samplefolder
	Prompt SampleFolder, "Select  data folder for sample", popup,  IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	setdatafolder $samplefolder
	variable/g root:P:gsdd,root:P:gycenter, root:P:gtopcut,root:P:grightcut
	If ((root:P:gsdd==0)||(root:P:gycenter==0)||(root:P:grightcut==0)||(root:P:gtopcut==0))
		getspecs()
	endif
	Average2DImage()

endmacro
		
proc Average2DImage(Name2D,xCenter,yCenter,SDD,PixelSize,qmask)//result is counts/bin/hour
	variable/g root:P:gxCenter,root:P:gyCenter,root:P:gSDD,root:P:gPixelSize
	string Name2D
	variable xCenter=root:P:gxCenter, yCenter=root:P:gyCenter
	variable SDD=root:P:gSDD,PixelSize=root:P:gPixelSize,numpts,qmask=root:P:qmask
	Prompt Name2D,"Enter the Image Name:",popup,WaveList("i*", ";", "")
	Prompt xCenter,"xCenter:(528)"
	Prompt yCenter,"yCenter:(459)"
	Prompt SDD,"Sam. to Det. Distance:(127.6cm)"
	Prompt PixelSize,"Pixel Size:(0.01317 cm/pixel)"
	Prompt qmask,"Mask the data?",popup "no;yes"
	
	Silent 1
	root:P:gSDD=SDD;root:P:gpixelsize=pixelsize;root:P:gxCenter=xCenter;root:P:gyCenter=yCenter
	variable xwidth=Dimsize($Name2D,0),yheight=Dimsize($Name2D,1)
	string header=note($Name2D)
 	string qout="q"+Name2D[1,27]+"_avg",rout="r"+Name2D[1,27]+"_avg",sout="s"+Name2D[1,27]+"_avg",NOut="N"+Name2D[1,27]+"_avg"
 	numpts=150
	make/n=(numpts)/o/d $qout,$rout,$sout,$NOut//name too long
	if (stringmatch(root:P:maskname,""))
		doalert 0, "You have not defined a mask."
		//Make1and0Images(xwidth,ywidth)
	endif
	string mask=root:P:maskname//"imask"
	Print "averaging "+Name2D
 	AverageName2DGeorg($Name2D,$mask,$qout,$rout,$sout,$Nout,xcenter,ycenter,qmask)
 	
 	variable wavelength=root:P:wavelengthvalue
	variable index=root:P:rindex	
	duplicate/o $qout, theta
	theta=atan(PixelSize*$qout/SDD)
	$qout=(4*pi/wavelength)*sin(theta/2)
	
 	variable/g livetime
 	$rout=$rout*3600/livetime//counts/stradian/hour
 	$sout=$sout*3600/livetime;doupdate
 	if(wavelength==1.54)
 		note $rout, header+"counts/unit solid angle/hour"
 	endif
 	if (qmask==1)
 		variable/g root:P:gvalue0//cutoff value for mask.  Typically 50%
 		note $rout, "masked value0= "+num2str(root:P:gvalue0)
 	endif
 	killwaves/z Rvalues2D,theta//, $Nout
 	
endmacro

Function SolidangleCorrection()
	SVAR basename
	string qwavenm=("q"+basename+"_avg_N_B"); string rwavenm=("r"+basename+"_avg_N_B")
	NVAR pixelsize=root:P:gpixelsize
	NVAR SDD=root:P:gsdd
	NVAR wavelength=root:P:wavelengthvalue
	NVAR index=root:P:rindex
	wave qwave=$qwavenm
	duplicate/o qwave, omega, SAP, HYP,theta
	theta=atan(pixelsize*p/sdd)
	
 	SAP=PixelSize*sin((pi/2)-theta)
 	HYP=((PixelSize*p)^2+SDD^2)^(1/2)
 	omega=(SAP/HYP)
 	duplicate/o theta, PF
 
	PF= (1+cos((theta))^2)/2// polarization factor
	if(wavelength>1000)
		//snell(wavelength,theta,index,qwave,PF)
		PF = 1
	endif
	wave rwave=$rwavenm
 	rwave=rwave/(omega^2*PF) 	//not obvious this should be squared  Needed for solid angle
 	killwaves/z  SAP, HYP, omega, PF
 		//duplicate/o $qout, theta
 		//theta=atan(PixelSize*$qout/SDD)
 		//wavelength=1.54
 		//$qout=(4*Pi*(sin(theta/2)))/wavelength	
 		//$rout=($rout/(PixelSize*sin((pi/2)-theta)))/(((PixelSize*$qout)^2+SDD^2)^.5)^2//per steradian
 	//ENDIF 	
 	//$rout*=(((sdd^2)+(PixelSize*$qout)^2))/sdd^2	//correct for 1/r^2 GBB
 	//$rout/=cos(atan(PixelSize*(0.5+$qout)/SDD))//Correct for flat detector DWS 	
end

function snell(wavelength,theta,index,qwave,PF)
	variable wavelength, index
	wave qwave,theta,PF
 		PF=1//VERTICALLY POLARIZED LASER
 		Doalert 1, "Do Snell correction?"
 		If (V_flag==1)//Said yes to snell
 			qwave=(4*Pi/wavelength)*sin(asin(sin(theta)/index)/2)//dws snell 		
 		endif
 end
 	
function AverageName2DGeorg(Name2D,mask,qout,rout,sout,NOut,xcenter,ycenter,qmask)
	wave Name2D,qout,rout,sout,Nout,mask
	variable xcenter,ycenter,qmask
	variable xwidth=Dimsize(Name2D,0)
	variable yheight=Dimsize(Name2D,1)
	duplicate/o Name2D Rvalues2D
	Rvalues2D=round(sqrt((x-xcenter)^2+(y-ycenter)^2))
	//Get Max distance from the center
	variable maxchannel=round(sqrt((xcenter-0)^2+(ycenter-0)^2))
	if(round(sqrt((xwidth-xcenter)^2+(ycenter-0)^2))>=maxchannel)
		maxchannel = round(sqrt((xwidth-xcenter)^2+(ycenter-0)^2))
	endif
	if(round(sqrt((xcenter-0)^2+(yheight-ycenter)^2))>=maxchannel)
		maxchannel = round(sqrt((xcenter-0)^2+(yheight-ycenter)^2))
	endif
	if(round(sqrt((xwidth-xcenter)^2+(yheight-ycenter)^2))>=maxchannel)
		maxchannel = round(sqrt((xwidth-xcenter)^2+(yheight-ycenter)^2))
	endif
	//Make the output waves spaced at one channel
	Redimension/N=(maxchannel+1) qout,rout,nout,sout
	qout=p;rout=0;sout=0;nout=0

	//Go through the array placing the intensity where it goes, spaced at one channel
	variable xcount=0,ycount=0
			If ((!waveexists(mask))&&(qmask==1))
				Doalert 0, "Mask does not exist"
				abort
			endif
	do
		do	
			//only add the counts for this pixel if mask is one or data is not masked at all
			if (qmask==0)//dont mask 
				rout[(Rvalues2D(xcount)(ycount))]+=Name2D(xcount)(ycount)//problem is previous line  Mask not defined
				Nout[(Rvalues2D(xcount)(ycount))]+=1
			else //mask
				if (mask(xcount)(ycount)==1)//make sure you have defined an imask, qmask==0 means don't mask (ie always count it)
					rout[(Rvalues2D(xcount)(ycount))]+=Name2D(xcount)(ycount)//problem is previous line  Mask not defined
					Nout[(Rvalues2D(xcount)(ycount))]+=1
				endif
			endif
			xcount+=1
		while(xcount<xwidth)
		xcount=0
		ycount+=1
	while(ycount<yheight)
	
	rout=rout/Nout	//r is intensity.  q in pixels
	sout= rout/sqrt(Nout)	
	killwaves Rvalues2D
End

macro getParameters(Diode0,Diode1,text,thick,absIn,dark)
	variable/g root:P:absIntenMult=1
	variable Diode0=1,Diode1=1,thick=10,absIn=root:p:absIntenMult,dark=0//-.026
	string, folder=getdatafolder(0)
	string text="Diode0: sample out of beam"
	Prompt Diode0,text
	Prompt Diode1,"Diode:  "+folder+"  in beam"
	Prompt thick,"Thickness (mm)"
	Prompt absIn,"Absolute Intensity Multiplier (1)"
	Prompt dark,"Diode Dark Current (-.026)"
	variable/g transmission=(diode1-dark)/(diode0-dark),thickness=thick
	root:P:absIntenMult=absIn
	variable/g absI=absIn
endmacro

Macro OpenTextFile()
	LoadWave/J/A=Georg/K=0/L={0,36,0,0,0} ""
	String/g gName2D
	gName2D=S_Filename
	gName2D=CorrectoBaseaNameo(gName2D)
	GetName2()
	rename georg0 $gName2D
	Redimension/N=(1024,1024) $gName2D
	Display;AppendImage $gName2D;DelayUpdate
	ModifyImage $gName2D ctab= {*,*,PlanetEarth,0}
EndMacro

function Make2D()
	string Samplefolder
	Prompt SampleFolder, "Select  data folder for sample", popup,  IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	doprompt "Pick Folder",SampleFolder

	setdatafolder $samplefolder
	Make2DImage("",1)
endmacro

function Make2DImage_blind(Name2D, qlog)
	String Name2D
	variable qlog
	 DWS_Initialize2Dto1DConversion()
	string/g activeimage=name2d
	NVAR qlogloc=root:Packages:SAS_Modeling:qlog
	qlogloc=qlog
	wave w=$name2d
	duplicate/o w, itemp
	if (qlog==1)
		itemp=log(itemp)
	endif
	variable horzdim, vertdim
	horzdim=dimsize(w, 0)//added to define 2d images according to file size RJ
	vertdim=dimsize(w, 1)//added to define 2d images according to file size RJ
	variable leftmarg=450, rightmarg=500, topmarg=320, botmarg=300

	
	dowindow/K Azamuthal;delayupdate
	dowindow/K Imageplot;delayupdate
	//Display/K=1/W=(leftmarg,topmarg,leftmarg+rightmarg,topmarg+botmarg)
	//AppendImage itemp;DelayUpdate//;DelayUpdate    /W=(left,top,right,bottom );DelayUpdate

	NVAR qmask=root:P:qmask
	if(qmask==1)	
		maskimage(qmask)
	endif
	newimage/K=1 itemp
	ModifyImage itemp ctab= {*,*,YellowHot,0}
	SetAxis/A/R left
	modifygraph margin(left)=14,margin(right)=11,margin(top)=90,margin(bottom)=11;DelayUpdate
	ModifyGraph height={Aspect,1}
	dowindow/c Imageplot;DelayUpdate

	DrawText 0.05,-0.03,Name2D;DelayUpdate
	string/g activeimage=Name2d
	NVAR logit=root:Packages:Convert2Dto1D:qlog
	logit=qlog
	CheckBox Logimage, pos={400,5},proc=AFRL_CheckProc,title="Log",value=qlog
	Button FindCenter size={80,20},pos={170,2},proc=DWSP_InputPanelButtonProc,title="Find Center";DelayUpdate
	Button ShowCenter size={80,20},pos={170,27},proc=DWSP_InputPanelButtonProc,title="Show Center"
	Button Mask size={50,20},pos={100,2},proc=DWSP_InputPanelButtonProc,title="Mask"
	Button Unmask size={50,20},pos={100,27},proc=DWSP_InputPanelButtonProc,title="Unmask"
	Button Mancent size={100,20},pos={280,2},proc=DWSP_InputPanelButtonProc,title="Manual Center"
		NVAR ImageRangeMin=root:Packages:Convert2Dto1D:ImageRangeMin
		NVAR ImageRangeMax=root:Packages:Convert2Dto1D:ImageRangeMax
		NVAR ImageRangeMinLimit=root:Packages:Convert2Dto1D:ImageRangeMinLimit
		NVAR ImageRangeMaxLimit=root:Packages:Convert2Dto1D:ImageRangeMaxLimit
		wavestats/Q itemp
		ImageRangeMin =V_min
		ImageRangeMax =V_max
		ImageRangeMinLimit = V_min
		ImageRangeMaxLimit =V_max
	Slider ImageRangeMin,size={150,16},pos={280,22},proc=DWS_MainSliderProc,variable= root:Packages:Convert2Dto1D:ImageRangeMin,live= 0,side= 2,vert= 0,ticks= 0
	Slider ImageRangeMin,limits={ImageRangeMinLimit,ImageRangeMaxLimit,0}
	
	Slider ImageRangeMax,size={150,16},pos={280,44},proc=DWS_MainSliderProc,variable= root:Packages:Convert2Dto1D:ImageRangeMax,live= 0,side= 2,vert= 0,ticks=0
	Slider ImageRangeMax,limits={ImageRangeMinLimit,ImageRangeMaxLimit,0}
	
Endmacro


function Make2DImage(Name2D, qlog)
	String Name2D
	variable qlog
	Prompt Name2D,"Enter the DataSetName:",popup,WaveList("i*", ";", "")
	Prompt qlog, "Log/linear", popup, "Log;Linear"
	doprompt "Pick Image", Name2D,qlog
	make2Dimage_blind(Name2D, qlog)
	ShowInfo
end
	


function maskimage1()
	string ImagenameSTR
	ImageNameStr="itemp"
	string  folderpath
	folderpath =getwavesDataFolder(ImageNameToWaveRef("", ImageNameStr),1)
	setdatafolder folderpath
	variable flag
	do
		DoAlert 2, "Mask image?"
		flag=v_flag
		SVAR Activeimage
		SVAR maskname=root:P:maskname
		wave maskwave=$maskname
		wave activeimagewave=$activeimage
		NVAR qlog=root:packages:SAS_Modeling:qlog
		wave itemp
		if (flag==1)
			if (waveexists(maskwave)==1)
			 	if (qlog==1)
					itemp=log(activeimagewave*maskwave)//wrong data folder?  Must use "View2D to make image"
				else
					itemp=activeimagewave*maskwave
				endif
			else 
				itemp=activeimagewave
				doalert 0,"Mask does not exist"
			endif
		endif
		If(flag==2)
			if (qlog==1)
				itemp=log(activeimagewave)//wrong data folder?
			else
				itemp=(activeimagewave)
			endif	
		endif
		doupdate
	while(flag!=3)	
end




function Fitto2DGaussian()
	string ImagenameSTR
	Storemarquee()
	ImageNameStr="itemp"
	string  folderpath
	folderpath =getwavesDataFolder(ImageNameToWaveRef("", ImageNameStr),1)
	setdatafolder folderpath
	string cmd
	cmd="Fitto2DGaussian1(,,,,\"itemp\",,,,)"
	execute cmd
	execute "DrawCenter()"
end

function StoreMarquee()
	variable/g root:P:top,root:P:bottom,root:P:left,root:P:right
	NVAR top=root:P:top,bottom=root:P:bottom,left=root:P:left,right=root:P:right
	
	silent 1
	GetMarquee left,top//bottom
	if(v_flag==0)
		doalert 0, "MAKE A MARQUEE ON THE GRAPH FIRST!!!!!!!"
		return 0
	ELSE
		top=v_top;bottom=v_bottom;left=v_left;right=v_right
		return 1
	endif
EndMacro

Macro DrawExistingAverageBox()
	variable/g root:P:left,root:P:right,root:P:top,root:P:bottom
	
	StoreMarquee()
	getwindow kwtopwin,wavelist
	string wavename=w_wavelist[0]
	getwindow kwtopwin,hook //sets s_value to the topwindow's name...
	setdrawenv fillpat=0,xcoord=bottom,ycoord=left,save
	SetDrawEnv linethick=3
	DrawRect root:P:left,root:P:top,root:P:right,root:P:bottom
EndMacro

Function Gaussian2D(w,x1,y1)
	Wave w;Variable x1 , y1//x is chann
	return(w[0]*exp(-((x1-w[1])^2+(y1-w[2])^2)/w[3]^2))
end


Proc Fitto2DGaussian1(left,right,bottom,top,wavename,PeakInt,xcenter,ycenter,stddev)
	variable/g root:P:left,root:P:top,root:P:right,root:P:bottom
	variable/g root:P:gPeakInt,root:P:gxcenter,root:P:gycenter,root:P:gstddev
	Variable left=root:P:left,right=root:P:right,bottom=root:P:bottom,top=root:P:top
	variable PeakInt=5,xcenter=root:P:gxcenter,ycenter=root:P:gycenter,stddev=150
	string wavename
	Prompt wavename,"image? (Use data browser):",popup,WaveList("*", ";","WIN:")
	Prompt left,"Enter the starting x position:"
	Prompt right,"Enter the end x position:"
	Prompt bottom,"Enter the starting y position:"
	Prompt top,"Enter the end y position:"
	Prompt peakInt,"Starting Peak Intensity(1000):"
	Prompt xcenter,"Starting x center(522):"
	Prompt ycenter,"Starting y center(460):"
	Prompt stddev,"Starting sigma(150):"
	
	Silent 1
	root:P:left=left ;root:P:right=right ;root:P:bottom=bottom ;root:P:top=top 
	root:P:gPeakInt=PeakInt ;root:P:gxcenter=xcenter ;root:P:gycenter=ycenter ;root:P:gstddev=stddev
	Make/o/n=4 root:P:gw2DGaussian
	root:P:gw2DGaussian[0]=root:P:gPeakInt;root:P:gw2DGaussian[1]=root:P:gxcenter;root:P:gw2DGaussian[2]=root:P:gycenter;root:P:gw2DGaussian[3]=root:P:gstddev
	FuncFitMD gaussian2D, root:P:gw2DGaussian, $waveName(left,right)(bottom, top) //d //Pointing at wrong folder.  Use data browser.
	//print ""
	//Print "For Data Set:  "+wavename
	//print "Peak Intensity = "+num2str(root:P:gw2DGaussian[3]*sqrt(2*pi)*root:P:gw2DGaussian[0])+" X Center = "+num2str(root:P:gw2DGaussian[1])
	//print "Y Center = "+num2str(root:P:gw2DGaussian[2])+" Standard Dev. = "+num2str(root:P:gw2DGaussian[3]/sqrt(2))
	//print "Area of Gaussian = "+num2str(pi*root:P:gw2DGaussian[0]*root:P:gw2DGaussian[3]^2)
	//Print ""
	//print root:P:gw2DGaussian[0]
	peakInt=root:P:gw2DGaussian[0];xcenter=root:P:gw2DGaussian[1];ycenter=root:P:gw2DGaussian[2];stddev=root:P:gw2DGaussian[3]
	root:P:gPeakInt=peakint;root:P:gxcenter=xcenter;root:P:gycenter=ycenter;root:P:gstddev=stddev
	string centers
	centers="xcent = "+num2str(xcenter)+"\rycnet = "+num2str(ycenter)//ORNL starts with 1 not 0
	TextBox/C/N=text1/A=MB centers
	wavename="fit_"+wavename
	//AppendMatrixContour $wavename
	//ModifyContour $wavename labelBkg=0
	//ModifyContour  $wavename labels=0
	killwaves root:P:gw2DGaussian,w_sigma,w_paramconfidenceinterval
	Root:P:gxcenter=xcenter;root:P:gycenter=ycenter
Endmacro

proc Setup(sam,mt,sen,dark)
	string/g root:P:gsam,root:P:gmt,root:P:gsen,root:P:gdark
	string sam=root:P:gsam,mt=root:P:gmt,sen=root:P:gsen,dark=root:P:gdark
	Prompt sam,"Sample: ",popup,"root:;"+DMACorrDir(datafolderdir(1)[7,strlen(datafolderdir(1))])
	Prompt mt,"MT: ",popup,"root:;"+DMACorrDir(datafolderdir(1)[7,strlen(datafolderdir(1))])
	Prompt sen,"Sensitivity: ",popup,"root:;"+DMACorrDir(datafolderdir(1)[7,strlen(datafolderdir(1))])
	Prompt dark,"Dark: ",popup,"root:;"+DMACorrDir(datafolderdir(1)[7,strlen(datafolderdir(1))])
	
	setdatafolder $sam
	root:P:gsam=sam;root:P:gmt=mt;root:P:gsen=sen;root:P:gdark=dark
	sam="root:P:"+sam+":";mt="root:P:"+mt+":";sen="root:P:"+sen+":";dark="root:P:"+dark+":"
	//string sampath=sam,mtpath=mt,senpath=sen,darkpath=dark
endmacro

proc Correct1dor2d()//also generates _N_B waves, but works for 2d
//results are in counts/pixel/hr
	setdatafolder root:P
	variable/g gtopcut,gycenter, gsdd,grightcut
	If(( gtopcut==0)||(gycenter==0)||(gsdd==0)||grightcut==0)
		getspecs()
	endif
	setdatafolder root:
	CorrectDWS(root:P:gsam,root:P:gmt,root:P:gsen,root:P:gdark,root:P:gmask,root:P:qmask,)
	
endmacro

	
	
proc CorrectDws(sampath,mtpath,senpath,darkpath,maskpath,qmask,dim)//sensitivy, transmission and background subtraction
	//assumes beam power does not change
	//generages _cor wave
	string/g root:P:gsam,root:P:gmt,root:P:gsen,root:P:gdark,root:P:dim,root:P:gmask
	variable/g root:P:qmask 
	variable qmask=root:P:qmask
	string sampath=root:P:gsam,mtpath=root:P:gmt,senpath=root:P:gsen,darkpath=root:P:gdark,maskpath=root:P:gmask,dim="i"
	Prompt sampath,"Sample: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt senpath,"Sensitivity: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt mtpath,"MT: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt darkpath,"Dark: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt maskpath,"Mask (typically sensitivity folder)",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt qmask,"Mask dataTypically sensitivity folder (1d only)?",popup "no:yes"
	Prompt dim,"1d (rwave) or2d (image)",popup,"r;i"

	root:P:gsam=sampath;root:P:gmt=mtpath;root:P:gsen=senpath;root:P:gdark=darkpath;root:P:gmask=maskpath;root:P:qmask=qmask;root:P:dim=dim
	//sampath="root:"+sampath+":";mtpath="root:"+mtpath+":";senpath="root:"+senpath+":";darkpath="root:"+darkpath+":";maskpath="root:"+maskpath+":"
	setdatafolder $sampath
	variable/g transmission
	string/g basename
	variable livetime=$(sampath+"livetime"),mttime=$(mtpath+"livetime"),darktime=$(darkpath+"livetime"),sentime=$(senpath+"livetime")	
	variable mttrans=$(mtpath+"transmission"),a
	if (strsearch(dim,"r",0)==0)
		string ext="_avg"//works on cricularly averaged waves if dim = "r"
	else
		string ext	//works on raw i wave if dim = "i"
	endif
		string sample=sampath+dim+basename[0,100]+ext
		string dark=darkpath+dim+($(darkpath+"basename"))+ext
		string mask=maskpath+"imask"
		string sen=senpath+dim+($(senpath+"basename"))+ext
		string mt=mtpath+dim+($(mtpath+"basename"))+ext
		string Rout=dim+basename+ext+"_cor"
		print rout
	if (strsearch(dim,"i",0)==0)//2d wave 
			make/o/n=(DimSize($Sample, 0),DimSize($sample, 1)) $Rout	// wrong folder or wavename or basename corrupted
			duplicate/O $sen,tempsen
			if ((waveexists($mask)==0)||(qmask==0))
				doalert 0, "Data Not masked"//may not be normalized correctly
			else
			tempsen*=$mask//tempsen is masked sensitivity wave,  may not exist
			endif	
			WaveStats/q  tempsen//gets average of sensitivity//unmasked
			killwaves/z tempsen	
		else//1d wave
			make/o/n=(numpnts($sample)) $Rout//make sure sensitivity & rwave masked, when _avg wave is generated	
			WaveStats/q $sen
			//r_avg wave is  counts/pixel
			//livetime=1;mttime=1;sentime=1;darktime=1//r_avg wave is already counts/hour
	endif
	a=v_avg*3600/sentime
		print "average z value of sensitivity= "+num2str(a)+" cts/pixel/hr"//normalization to compare to rwave a value
	//normalize back to roughly counts/hour
	$Rout=(a/transmission)*(($sample/livetime)-($dark/darktime))/(($sen/sentime)-($dark/darktime))
	$Rout-=(a/mttrans)*(($mt/mttime)-($dark/darktime))/(($sen/sentime)-($dark/darktime))//_avg files must exist
	If(!exists("thickness"))
		variable/g thickness=1
	endif
	variable/g absI
	if (absI==0)
		absI=1
	endif
	doalert 0,"Thickness = "+num2str(thickness)+" mm"+"\rAbsolute Intensity Multiplier ="+num2str(absI)+"\rLivetime ="+num2str(livetime)+"\rTransmission ="+num2str(transmission)
	$rout*=absI/(thickness*.1)
	note $rout,"MTpath = "+mtpath+"\rSensitivityPath = "+senpath+"\rdarkPath = "+darkpath
	if (strsearch(dim,"r",0)==0)
		string qout="q"+basename+ext+"_cor"
		string sout="s"+basename+ext+"_cor"	
		string qin=sampath+"q"+basename+ext
		string swin=sampath+"s"+basename+ext
		string smt=mtpath+"s"+($(mtpath+"basename"))+ext
		make/o/n=(numpnts($sample)) $qout
		$qout=$qin
		make/o/n=(numpnts($sample)) $sout
		$Sout=(a/transmission)*($swin/livetime+$smt/mttime)/($sen/sentime-$dark/darktime)//neglects dark and sensitivity error
		$Sout*=absI/(thickness*.1)
	endif
	string/g activeimage=sample+"_cor"
	if(strsearch(dim,"i",0)==0)
		Make2DImage_blind(rout,1)		
		 if (root:P:qmask==1)
	 		 maskimage(1)
		 endif
	else
		simpleloglogplot( qout,rout,"")
		If (absi=1)
			Label left "\\F'Helvetica'\\Z18Counts//hr/cm"
		endif
	 endif
End
	
proc Complete()
	variable/g root:P:gvalue0
	variable value0=root:P:gvalue0
	Setdatafolder root:
	FullAnalysis()
endmacro

proc FullAnalysis(sampath1,mtpath1,senpath1,darkpath1,maskpath1,qmask,redo)//1d only
	string/g root:P:gsam,root:P:gmt,root:P:gsen,root:P:gdark,root:P:gmask
	variable/g root:P:qmask ,root:P:redo
	variable qmask=2,redo=root:P:redo
	//string gmask=root:P:gmask
		string sampath1=root:P:gsam,mtpath1=root:P:gmt,senpath1=root:P:gsen,darkpath1=root:P:gdark,maskpath1=root:P:gmask
	Prompt sampath1,"Sample: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt senpath1,"Sensitivity: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt mtpath1,"MT: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt darkpath1,"Dark: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt maskpath1,"Mask (typically sensitivity folder)",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt qmask,"Mask data?",popup "no;yes"//no =1 yes=2
	prompt redo, "Redo Sensitivity, MT and Dark Circular averages?",popup "no;yes"//no =1 yes=2


	If (root:Packages:SAS_Modeling:VC==0)
		doalert 0, "Enter Machine Parameters First"
		GetSpecs()
	endif
	root:P:gsam=sampath1;root:P:gmt=mtpath1;root:P:gsen=senpath1;root:P:gdark=darkpath1;root:P:gmask=maskpath1;root:P:qmask=qmask
	string/g root:P:maskname=maskpath1+"imask"
	root:P:redo=redo
	String Name2d
	setdatafolder sampath1
	Name2d="i"+basename
		if (!waveexists($Name2d))
			DoAlert 0, "Sample image does not exist"
			abort
		endif
	Average2DImage(Name2d,xcenterlcl, ycenterlcl,root:P:gSDD,root:P:gPixelSize,qmask)
	
	setdatafolder $senpath1
	string/g basename
	//circularly averaged waves (_avg) are in counts/pixel
	//check to see if all averaged waves exist	
	if((waveexists($("r"+basename+"_avg"))!=1)|(redo==2))
		Name2d="i"+basename
		Average2DImage(Name2d,xcenterlcl, ycenterlcl, root:P:gSDD,root:P:gPixelSize,qmask)
	endif

	setdatafolder $mtpath1
	if((waveexists($("r"+basename+"_avg"))!=1)|(redo==2))
		Name2d="i"+basename
		Average2DImage(Name2d,xcenterlcl, ycenterlcl,root:P:gSDD,root:P:gPixelSize,qmask)
	endif

	setdatafolder darkpath1
	if((waveexists($("r"+basename+"_avg"))!=1)|(redo==2))
		Name2d="i"+basename
		Average2DImage(Name2d,xcenterlcl, ycenterlcl,root:P:gSDD,root:P:gPixelSize,qmask)
	endif
	
	SubtractDCandNormalize(mtpath1,darkpath1,senpath1)//multiplies by a/transmisssion
	SubtractDCandNormalize(sampath1,darkpath1,senpath1)//multiplies by a/transmisssion
	//_N waves are in g/pixel
	subractBackgroundFromNormalized(sampath1, mtpath1)
	setdatafolder sampath1 
	//SolidangleCorrection()//should be done after bkg subtractions
	string qwave=("q"+basename+"_avg_N_B");String rwave=("r"+basename+"_avg_N_B");string swave=("s"+basename+"_avg_N_B")
	variable drop=root:P:drop
	variable/g rank=numpnts($qwave)//needed for deleting points
	variable/g root:P:drop,root:P:updrop
	root:P:drop=0;root:P:updrop=0
	setdatafolder root:
	 plotall1(sampath1, mtpath1)
	 
end

Macro subback()
	setdatafolder root:
	subractBackgroundFromNormalized()
endmacro
	
Macro subractBackgroundFromNormalized(sampath, mtpath)//1d _avg data only use  CorrectDws for 2d waves
	string/g root:P:gsam,root:P:gmt
	string sampath=root:P:gsam,mtpath=root:P:gmt	
	Prompt sampath,"Sample: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt mtpath,"MT: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
		
	setdatafolder $sampath
	root:P:gsam=sampath;root:P:gmt=mtpath
	string/g basename
	string sample=sampath+"r"+basename+"_avg_N"
	string mt=mtpath+"r"+($(mtpath+"basename"))+"_avg_N"
	string Rout="r"+basename+"_avg_N_B"
	string qout="q"+basename+"_avg_N_B"
	string sout="s"+basename+"_avg_N_B"	
	string qin=sampath+"q"+basename+"_avg_N"
	string swin=sampath+"s"+basename+"_avg_N"
	string smt=mtpath+"s"+($(mtpath+"basename"))+"_avg_N"
	Make/o/n=(numpnts($sample)) $rout,$qout,$sout
	//add do alert here to alert user that the name is too long if you get this error
	//
	
	$rout=$sample-$mt

	variable/g thickness
	if (thickness==0)
		thickness=1//in mm
	endif
	variable/g absI
	if (absI==0)
		absI=1
	endif
	doalert 0,"Thickness = "+num2str(thickness)+" mm"+"\rAbsolute Intensity Multiplier = "+num2str(absI)
	$rout*=absI/(thickness*0.1)//intensity is differential crossection in cm-1
	note $rout,"MTpath = "+mtpath+"\rtransmission = " +num2str(transmission)+"\rthickness = "+num2str(thickness)+" mm"
	$qout=$qin
	$sout=(($swin)+$smt)*absI/(thickness*.1)

	//killwaves/z $sample,$qin,$swin
	
endmacro

macro Plot_N_B_Data()
	SetOperationFolder()
	string/g basename;  string Ya,Xa
	Ya="r"+basename+"_avg_N_B"
	Xa="q"+basename+"_avg_N_B"
	
	LoglogPlot(Xa,Ya,1,1,4,1)
	If (absi==1)
		Label left "\\F'Helvetica'\\Z18Counts//hr/cm"//changed to omega RJ
	endif
end
	
Macro	Plotall()
	setdatafolder root:
	plotall1()
end
	
Macro plotall1(sampath, mtpath)//1d _avg data only use  CorrectDws for 2d waves
	string/g root:P:gsam,root:P:gmt
	string sampath=root:P:gsam,mtpath=root:P:gmt
	Prompt sampath,"Sample: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt mtpath,"MT: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
		
	setdatafolder sampath
	root:P:gsam=sampath;root:P:gmt=mtpath
	string/g basename
	string rsample_N="r"+basename+"_avg_N"
	string qsample_N="q"+basename+"_avg_N"
	string rmt_N=mtpath+"r"+($(mtpath+"basename"))+"_avg_N"
	string qmt_N=mtpath+"q"+($(mtpath+"basename"))+"_avg_N"
	string rsample_N_B="r"+basename+"_avg_N_B"
	string qsample_N_B="q"+basename+"_avg_N_B"
	if (!waveexists($rsample_N_B))
			Doalert 0,"Wave does not exist"
		else
			Display/k=1 $rsample_N_B vs $qsample_N_B
			appendtograph $rsample_N vs $qsample_N
			appendtograph $rmt_N vs $qmt_N
			ModifyGraph log=1
			Legend/C/N=text0/A=MC
			
			
			SetAxis/A
			ChangetoLineandPoints(4,1)
			If (absi==1)
				Label left "\\F'Helvetica'\\Z18Counts//hr/cm"
			endif
		endif
		string ListOfGraphFormating=root:Packages:GeneralplottingTool:ListOfGraphFormating
	root:Packages:GeneralplottingTool:ListOfGraphFormating=ReplaceNumberByKey("ErrorBars",ListOfGraphFormating,1,"=")//(keyStr, kwListStr  [, keySepStr  [, listSepStr ]])
	
	DWS_AttachErrorBars()
endmacro
	
macro cleanupsens()
	setdatafolder root:
	cleanupsens1()
endmacro

macro cleanupsens1(sens)
	string sens=root:P:gmask
	prompt sens,"Sensitivty Folder",popup,IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	//Prompt qmask, "Mask Sensitivity?",popup "no:yes"
	
	root:P:gmask=sens
	setdatafolder sens
	string/g basename
	string Wave2d="i"+basename
	$Wave2d[0,70][0,(dimsize($Wave2d,0))]=0//eliminates runaway cells in col 18 
	$Wave2d[983,1023][0,(dimsize($Wave2d,0))]=0//eliminates runaway cells in col 18 
	Make2DImage(Wave2d, 1)	
endmacro


function ConvertIlavskyMask(name)//changes zeros to ones and rest to nans
	wave name
	
	pauseupdate
	silent 1	
	variable counterx=0,countery=0,Z,maxx,maxy
	maxx=DimSize(name, 0)
	maxy=DimSize(name, 1)
	do
		do
			Z=name[counterx][countery]
			if(Z==0)
				name[counterx][countery]=nan
			endif
			counterx+=1
		while(counterx<=(maxx-1))
		counterx=0
		countery+=1
	while (countery<=(maxy-1))
End
end

proc makeMask(Maskpath,value0,NewWave)//newwave typicall "imask"
	variable/g root:P:gvalue0
	variable value0= 0//must be greater than 0 to acutally mask
	string/g root:P:gmask
	string Maskpath=root:P:gmask,NewWave="imask"
	Prompt maskpath,"Mask (typically sensitivity folder)",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	prompt value0,"Mask below what % of average sensitivty (50)"
	Prompt NewWave,"Mask Name (imask)"	
	setdatafolder maskpath
	root:P:gmask=Maskpath;root:P:gvalue0=value0
	string Mask_2d=maskpath+"i"+$(maskpath+"basename")
	string/g root:P:maskname=maskpath+"imask"
	duplicate/o $Mask_2d $NewWave
	MakeMaskFun($Newwave,value0)//puts zeros when below minval
	DoAlert 0,"If you wish to adjust mask, place marquee over beam stop and\r execute 'mask (or unmask) points inside (outside)marquee'"
endmacro


function MakeMaskFun(name,minval)//puts zeros when below minval
	wave name
	variable minval
	
	pauseupdate
	silent 1
	print "Points below minval = "+num2str(minval)+"  will be changed to NaN"
	variable counterx=0,countery=0,Z,maxx,maxy
	maxx=DimSize(name, 0)
	maxy=DimSize(name, 1)
	do
		do
			Z=name[counterx][countery]
			if(Z<minval)
				name[counterx][countery]=nan
			else
				name[counterx][countery]=1
			endif
			counterx+=1
		while(counterx<=(maxx-1))
		counterx=0
		countery+=1
	while (countery<=(maxy-1))
End

macro FindCenter()
	setdatafolder root:
	FindCenter1()
	Make2DImage(sample, 0)
endMacro

macro FindCenter1(sampath,mtpath,senpath,darkpath,Maskpath,qmask)
	string/g root:P:gsam,root:P:gmt,root:P:gsen,root:P:gdark,root:P:gmask
	variable qmask = 1
	string sampath=root:P:gsam,mtpath=root:P:gmt,senpath=root:P:gsen,darkpath=root:P:gdark,Maskpath=root:P:gmask
	Prompt sampath,"Sample for center analysis: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt mtpath,"MT: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt senpath,"Sensitivity: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	Prompt darkpath,"Dark: ",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)
	prompt maskpath,"Mask:",popup, IN2G_FindFolderWithWaveTypes("root:", 5, "i*", 1)	
	Prompt qmask,"Mask the data?",popup "no;yes"

	root:P:gsam=sampath;root:P:gmt=mtpath;root:P:gsen=senpath;root:P:gdark=darkpath;root:P:gmask=Maskpath
	//sampath="root:P:"+sampath;mtpath="root:P:"+mtpath;senpath="root:P:"+senpath;darkpath=":"+darkpath
	setdatafolder $sampath
	string/g basename
	string sample="i"+basename+"_cor"
	If (!WaveExists($sample))
		 CorrectDWS(sampath,mtpath,senpath,darkpath,maskpath,qmask,"i")//sensitivy, transmission and background subtraction
	endif
		
	Make2DImage_blind(SAMPLE, 1)
	DoAlert 0, "Set up the marquee on the beam center and press Find Center"
endmacro

function Maskutility(,inside,value,type)//1 = inside,  nan, 2 = box
	variable value,type,inside
	
	variable marquee=0
	marquee=storemarquee()//look here
	if (marquee==0)
		abort
	else
		nvar bottom=root:P:top, top=root:P:bottom,left=root:P:left,right=root:P:right//mask may be upside down.  exchange top and bottom
		
		if (type==1)//circle
			ModifyMaskCircle(inside,value, bottom,top,left,right)
		else//box
			ModifyMaskBox(inside,value,bottom,top,left,right)
		endif
	endif
	maskimage(1)
end

function ModifyMaskCircle(inside,value, bottom,top,left,right)
	variable inside, value,bottom,top,right,left

	SVAR imagename=root:P:maskname
	if(!SVAR_Exists(imagename))
		STRING/g Root:P:maskname="imask"
	endif
	wave image=$imagename
	bottom=ceil(bottom);left=ceil(left);right=floor(right);top=floor(top)
	variable xcen=(left+right)/2,ycen=(top+bottom)/2
	variable rmax=round(sqrt((.5*(right-left))^2+(.5*(top-bottom))^2))
	variable xmax=xcen+rmax,ymax=ycen+rmax, r,x,y=ycen-rmax
	Pauseupdate
	do
		 x=xcen-rmax
		do
			r=round(sqrt((x-xcen)^2+(y-ycen)^2))
			if ((r<=rmax)&&(inside))//mask inside circle
				image[x][y]=value
			endif
			if  ((r>rmax)&&(!inside))//mask outsive
				image[x][y]=value
			endif
			x=x+1	
		while( x<=xmax)
		y=Y+1
	while (y<=ymax)
end

function ModifyMaskBox(inside,value, bottom,top,left,right)
	variable inside,value,bottom,top,right,left

	svar imagename=root:P:maskname
	wave image=$imagename
	bottom=ceil(bottom);left=ceil(left);right=floor(right);top=floor(top)
	variable x,y=bottom,height, width
	height=dimsize (image,0)
	width=dimsize (image,1)
	Pauseupdate
	if(inside)
		do//INSIDE
			 x=left
			do	
				image[x][y]=value
				x=x+1	
			while( x<=right)
			y=Y+1
		while (y<=top)
	else//OUTSIDE
		y=0
		do
			 x=0
			do	
				if ((x<left)||(x>right)||(y<bottom)||(Y>top))
					image[x][y]=value
				endif
				x=x+1	
			while( x<=width)
			y=Y+1
		while (y<=height)
	endif
end


Function/s AFRL_PopMenuProc(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum
	String popStr
	if (cmpstr(ctrlName,"sampath1")==0)
		sVAR sample=Root:P:gsam
		sample= popStr
		setdatafolder popStr
		SVAR basename
		
		if (exists("rank")==0)
			variable/g rank
		endif
		NVAR rank
		string rsample_N_B="r"+basename+"_avg_N_B"
		wave rsam_N_B=$rsample_N_B
		rank =numpnts(rsam_N_B)
		NVAR drop=root:P:drop;NVAR updrop=root:P:updrop
		drop=0;updrop=0
		dowindow/k Image
		
	endif
	if (cmpstr(ctrlName,"mtpath1")==0)
		sVAR mt=Root:P:gmt
		mt= popStr
	endif
	if (cmpstr(ctrlName,"darkpath1")==0)
		sVAR dark=Root:P:gdark
		dark= popStr
	endif
	if (cmpstr(ctrlName,"senpath1")==0)
		sVAR sen=Root:P:gsen
		sen= popStr
	endif
		if (cmpstr(ctrlName,"maskpath1")==0)
		sVAR mask=Root:P:gmask
		mask= popStr
		SVAR maskname=root:P:maskname
		maskname=popStr+"imask"
	endif
	if (cmpstr(ctrlName,"drop")==0)
		NVAR drop=Root:P:drop
		drop= popnum
	
	endif
End

Function AFRL_CheckProc(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	NVAR mask=root:P:qmask
	NVAR redo=root:P:redo
	NVAR Flip=root:P:FlipImage
	if (cmpstr(ctrlName,"logimage")==0)	
		wave itemp
		NVAR qlog=root:Packages:Convert2Dto1D:qlog
		qlog=checked
		if (!checked)
			itemp=10^itemp
		else
			itemp=log(itemp)
		endif
		NVAR ImageRangeMin=root:Packages:Convert2Dto1D:ImageRangeMin
		NVAR ImageRangeMax=root:Packages:Convert2Dto1D:ImageRangeMax
		NVAR ImageRangeMinLimit=root:Packages:Convert2Dto1D:ImageRangeMinLimit
		NVAR ImageRangeMaxLimit=root:Packages:Convert2Dto1D:ImageRangeMaxLimit
		wavestats/Q itemp
		ImageRangeMin = V_min
		ImageRangeMax =.1*V_max
		ImageRangeMinLimit = V_min
		ImageRangeMaxLimit = V_max
		Slider ImageRangeMin,size={150,16},pos={280,22},proc=DWS_MainSliderProc,variable= root:Packages:Convert2Dto1D:ImageRangeMin,live= 0,side= 2,vert= 0,ticks= 0
		Slider ImageRangeMin,limits={ImageRangeMinLimit,ImageRangeMaxLimit,0}
	
		Slider ImageRangeMax,size={150,16},pos={280,44},proc=DWS_MainSliderProc,variable= root:Packages:Convert2Dto1D:ImageRangeMax,live= 0,side= 2,vert= 0,ticks= 0
		Slider ImageRangeMax,limits={ImageRangeMinLimit,ImageRangeMaxLimit,0}
		ModifyImage itemp ctab= {*,*,YellowHot,0}	
	Endif
	
	
	if (cmpstr(ctrlName,"MaskData")==0)	
		mask=checked//yes =1
		//Maskimage(checked)
	Endif
	if (cmpstr(ctrlName,"FlipImage")==0)	
		Flip=1+checked//no =1 yes =2
		doalert 0,"Not implemented yet.\r  Should vertically flip the image"
	Endif
	if (cmpstr(ctrlName,"redo")==0)	
		redo=1+checked//no =1 yes =2
	Endif
End

Function DWS_Initialize2Dto1DConversion()

	string OldDf=GetDataFolder(1)
	NewDataFolder/O root:Packages
	NewDataFolder/O/S root:Packages:Convert2Dto1D
	string ListOfVariables="ImageRangeMin;ImageRangeMax;ImageRangeMinLimit;ImageRangeMaxLimit;qlog;"
	string ListOfStrings="ColorTableName;"
	variable i
	//and here we create them
	for(i=0;i<itemsInList(ListOfVariables);i+=1)	
		IN2G_CreateItem("variable",StringFromList(i,ListOfVariables))
	endfor		
	for(i=0;i<itemsInList(ListOfStrings);i+=1)	
		IN2G_CreateItem("string",StringFromList(i,ListOfStrings))
	endfor	
	
	SVAR ColorTableName
	ColorTableName="yellowhot"
	
	
	if (!DataFolderExists("root:Packages:SAS_Modeling"))
		newdatafolder/O root:Packages
		newdatafolder/O root:Packages:SAS_Modeling
	endif

	setdatafolder OldDF
end 

Function DWS_MainSliderProc(ctrlName,sliderValue,event) //: SliderControl
	String ctrlName
	Variable sliderValue
	Variable event	// bit field: bit 0: value set, 1: mouse down, 2: mouse up, 3: mouse moved

	if(cmpstr(ctrlName,"ImageRangeMin")==0 || cmpstr(ctrlName,"ImageRangeMax")==0)
		if(event %& 0x1)	// bit 0, value set
				DWS_TopCCDImageUpdateColors(0)
		endif
	endif
	//if(cmpstr(ctrlName,"ImageRangeMinSquare")==0 || cmpstr(ctrlName,"ImageRangeMaxSquare")==0)
	//	if(event %& 0x1)	// bit 0, value set
		//		NI1_SQCCDImageUpdateColors(0)
		//endif
	//endif
	return 0
End


Function DWS_TopCCDImageUpdateColors(updateRanges)
	variable updateRanges
	
	string oldDf=GetDataFOlder(1)
	setDataFolder root:Packages:Convert2Dto1D
	NVAR ImageRangeMin= root:Packages:Convert2Dto1D:ImageRangeMin
	NVAR ImageRangeMax = root:Packages:Convert2Dto1D:ImageRangeMax
	SVAR ColorTableName=root:Packages:Convert2Dto1D:ColorTableName
	NVAR ImageRangeMinLimit= root:Packages:Convert2Dto1D:ImageRangeMinLimit
	NVAR ImageRangeMaxLimit = root:Packages:Convert2Dto1D:ImageRangeMaxLimit
	String s= ImageNameList("", ";")
	Variable p1= StrSearch(s,";",0)
	if( p1<0 )
		abort			// no image in top graph
	endif
	s= s[0,p1-1]
	if(updateRanges)
		Wave waveToDisplayDis=$(s)
		wavestats/Q  waveToDisplayDis
		ImageRangeMin=V_min
		ImageRangeMinLimit=V_min
		ImageRangeMax=.1*V_max
		ImageRangeMaxLimit=V_max
		Slider ImageRangeMin,limits={ImageRangeMinLimit,ImageRangeMaxLimit,0}, win=NI1A_Convert2Dto1DPanel
		Slider ImageRangeMax,limits={ImageRangeMinLimit,ImageRangeMaxLimit,0}, win=NI1A_Convert2Dto1DPanel
	endif
	ModifyImage $(s) ctab= {ImageRangeMin,ImageRangeMax,$ColorTableName,0}
	setDataFolder OldDf
end
